package mc.garakrral.entity.goal;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1542;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3417;

public class StealGoldGoal extends class_1352 {
    private final class_1314 mob;
    private final double speed;
    private class_2338 targetBlock;
    private class_243 targetItemPos;
    private class_1542 targetItem;
    private int cooldown = 0;

    public StealGoldGoal(class_1314 mob, double speed) {
        this.mob = mob;
        this.speed = speed;
        // Sadece MOVE kontrolünü al, LOOK’u alma — diğer goal’lar çatışmasın
        this.method_6265(EnumSet.of(class_4134.field_18405));
    }

    @Override
    public boolean method_6264() {
        if (cooldown > 0) {
            cooldown--;
            return false;
        }

        class_1937 world = mob.method_37908();

        // 🔸 Öncelikle yerdeki altın eşyalar (bar veya blok)
        List<class_1542> items = world.method_8390(
                class_1542.class,
                new class_238(mob.method_24515()).method_1014(8.0D),
                item -> item.method_6983().method_31574(class_1802.field_8695) || item.method_6983().method_31574(class_1802.field_8494)
        );

        if (!items.isEmpty()) {
            targetItem = items.get(0);
            targetItemPos = targetItem.method_19538();
            targetBlock = null;
            return true;
        }


        // 🔸 Yakındaki altın bloklara bak
        class_2338 mobPos = mob.method_24515();
        for (class_2338 pos : class_2338.method_25996(mobPos, 5, 2, 5)) {
            if (world.method_8320(pos).method_27852(class_2246.field_10205)) {
                targetBlock = pos.method_10062();
                targetItemPos = null;
                return true;
            }
        }

        return false;
    }

    @Override
    public boolean method_6266() {
        return (targetItemPos != null || targetBlock != null);
    }

    @Override
    public void method_6269() {
        moveToTarget();
    }

    private void moveToTarget() {
        if (targetItemPos != null) {
            mob.method_5942().method_6337(targetItemPos.field_1352, targetItemPos.field_1351, targetItemPos.field_1350, speed);
        } else if (targetBlock != null) {
            mob.method_5942().method_6337(targetBlock.method_10263(), targetBlock.method_10264(), targetBlock.method_10260(), speed);
        }
    }

    @Override
    public void method_6268() {
        if (targetItem != null && targetItem.method_5805()) {
            double distance = mob.method_19538().method_1022(targetItem.method_19538());
            if (distance < 1.5D) {
                mob.method_6104(class_1268.field_5808);
                mob.method_5783(class_3417.field_15197, 1.0F, 1.0F);

                // 🔸 Item’ı gerçekten “çal”
                targetItem.method_31472(); // itemi yok et (çalındı)
                stopStealing();
            }
        } else if (targetBlock != null) {
            double distance = mob.method_19538().method_1022(class_243.method_24953(targetBlock));
            if (distance < 2.0D) {
                mob.method_6104(class_1268.field_5808);
                mob.method_5783(class_3417.field_15044, 1.0F, 1.0F);
                mob.method_37908().method_8651(targetBlock, true, mob);
                stopStealing();
            }
        }

    }

    private void stopStealing() {
        targetItem = null;
        targetItemPos = null;
        targetBlock = null;
        cooldown = 20 + mob.method_59922().method_39332(0, 20); // 1–2 saniye bekleme
        mob.method_5942().method_6340();
    }

    @Override
    public void method_6270() {
        mob.method_5942().method_6340();
        targetItemPos = null;
        targetBlock = null;
    }
}
