package mc.garakrral.entity.passive;

import mc.garakrral.xpjump.XpJump;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1315;
import net.minecraft.class_1621;
import net.minecraft.class_1657;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;

public class SnotBallEntity extends class_1621 implements XpJump {

    private static final class_2940<Boolean> TAMED =
            class_2945.method_12791(SnotBallEntity.class, class_2943.field_13323);

    // XP Jump sistemi
    private int jumpStrength = 0;
    private boolean isCharging = false;
    private float currentSpeed = 0.0F;           // anlık yatay hız katsayısı
    private boolean riderForward = false;
    private boolean riderSprintBrake = false;

    public SnotBallEntity(class_1299<? extends class_1621> type, class_1937 world) {
        super(type, world);
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1621.method_26828()
                .method_26868(class_5134.field_23716, 20.0D)
                .method_26868(class_5134.field_23719, 0.55D)
                .method_26868(class_5134.field_23721, 0.0D);
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(TAMED, false);
    }

    public boolean isTamed() {
        return this.field_6011.method_12789(TAMED);
    }

    public void setTamed(boolean b) {
        this.field_6011.method_12778(TAMED, b);
    }

    public void setRiderForward(boolean f) {
        this.riderForward = f;
    }

    public void setRiderSprintBrake(boolean b) {
        this.riderSprintBrake = b;
    }

    @Override
    public class_1315 method_5943(class_5425 w, class_1266 d, class_3730 r, class_1315 data) {
        class_1315 d0 = super.method_5943(w, d, r, data);
        try {
            this.method_7161(1, true);
        } catch (Exception ignored) {
        }
        return d0;
    }

    @Override
    protected class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (!this.method_37908().field_9236) {
            if (!isTamed() && player.method_5998(hand).method_31574(class_1802.field_8777)) {
                setTamed(true);
                player.method_5998(hand).method_7934(1);
                player.method_7353(class_2561.method_43470("SnotBall loves you now!"), true);
            } else if (isTamed()) {
                player.method_5873(this, true);
            }
        } else {
            if (isTamed()) player.method_5873(this, true);
        }
        return class_1269.field_5812;
    }

    @Override
    public void method_5773() {
        super.method_5773();

        if (this.method_5782() && this.method_31483() instanceof class_1657 player) {

            // yön kilidi
            this.method_36456(player.method_36454());
            this.field_5982 = this.method_36454();

            // yatay hareketi sıfırla
            class_243 v = this.method_18798();
            this.method_18800(0, v.field_1351, 0);

            player.field_6017 = 0.0F; //fall damage kapalı
        }
    }


    @Override
    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        setTamed(nbt.method_10577("Tamed"));
        try {
            method_7161(1, false);
        } catch (Exception ignored) {
        }
    }

    @Override
    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("Tamed", isTamed());
    }

    @Override
    public void setJumpStrength(int strength) {
        this.jumpStrength = Math.max(0, Math.min(100, strength));
    }

    @Override
    public boolean canJump() {
        return this.method_24828();
    }

    @Override
    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 source) {
        return false; // kapalı
    }

    @Override
    public void startJumping(int height) {
        this.isCharging = true;
    }

    @Override
    public void stopJumping() {
        if (!this.method_5805() || !this.method_5782()) {
            isCharging = false;
            return;
        }

        isCharging = false;

        class_1657 rider = (class_1657) this.method_31483();

        if (rider != null) {
            rider.field_6017 = 0.0F;
        }

        double min = 0.4D;
        double max = 1.6D;
        double power = min + ((double) jumpStrength / 100.0) * (max - min);

        class_243 look = rider.method_5828(1.0F).method_1029();

        double vx = look.field_1352 * power;
        double vy = power * 0.9;
        double vz = look.field_1350 * power;

        this.method_18800(vx, vy, vz);
        this.field_6007 = true;

        if (rider != null) {
            rider.field_6017 = 0.0F;
        }
    }

    @Override
    public void method_6043() {
        // kapandı
    }

    @Override
    public void method_6091(class_243 movementInput) {
        if (this.method_5782() && this.method_31483() instanceof class_1657 rider) {

            // yaw'ı rider'a göre kilitle (görüş)
            this.method_36456(rider.method_36454());
            this.field_5982 = this.method_36454();

            // parametreler: hedef hız katsayıları
            final float maxWalkSpeed = 0.35F;   // hız
            final float accel = 0.02F;         // hızlanma hızı (artış per tick)
            final float decel = 0.01F;         // yavaşlama per tick
            final float sprintBrakeFactor = 0.06F; // shift ile daha hızlı yavaşlama

            // Hedef hız: eğer riderForward true ise maxWalkSpeed, değilse 0
            float target = this.riderForward ? maxWalkSpeed : 0f;

            if (!this.riderForward) {
                // eğer shift ile frenleniyorsa daha hızlı frenle
                if (this.riderSprintBrake) {
                    // sprintBrake: güçlü fren
                    if (currentSpeed > 0f) currentSpeed = Math.max(0f, currentSpeed - sprintBrakeFactor);
                    else currentSpeed = Math.min(0f, currentSpeed + sprintBrakeFactor);
                } else {
                    // normal yavaşlama
                    if (currentSpeed > target) currentSpeed = Math.max(target, currentSpeed - decel);
                    else currentSpeed = Math.min(target, currentSpeed + accel);
                }
            } else {
                // riderForward true ise kademeli hızlan
                if (currentSpeed < target) {
                    currentSpeed = Math.min(target, currentSpeed + accel);
                } else if (currentSpeed > target) {
                    currentSpeed = Math.max(target, currentSpeed - decel);
                }
            }

            // apply horizontal velocity according to currentSpeed and rider look direction
            class_243 look = rider.method_5828(1.0F).method_1029();
            class_243 vel = this.method_18798();
            double vx = look.field_1352 * currentSpeed;
            double vz = look.field_1350 * currentSpeed;

            // koru düşey hız bileşeni
            this.method_18800(vx, vel.field_1351, vz);

            // passenger control: normal entity physics ile çakışmaması için
            super.method_6091(class_243.field_1353);
            return;
        }

        super.method_6091(movementInput);
    }


    public boolean collides() {
        return true;
    }

    public boolean canBeControlledByRider() {
        return true;
    }
}
