package mc.garakrral.event.totem.machine;

import java.util.Map;

import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import mc.garakrral.block.BlockType;
import mc.garakrral.data.OvenData;
import mc.garakrral.event.totem.machine.recipe.IndustrialOvenRecipes;
import mc.garakrral.event.totem.machine.recipe.IndustrialOvenRecipes.RecipeData;

import com.kaplanlib.api.scheduler.ServerScheduler;


public class INDUSTRIAL_OVEN {
    private static final OvenData ovenData = AutoConfig.getConfigHolder(OvenData.class).getConfig();

    public static class_1269 onUseBlock(class_1657 player, class_1937 world, class_1268 hand, class_3965 hit) {
        if (world.method_8608()) return class_1269.field_5811;

        class_2338 clickedPos = hit.method_17777();
        class_2680 state = world.method_8320(clickedPos);

        // Only works for the industrial oven block
        if (!state.method_27852(BlockType.INDUSTRIAL_OVEN)) {
            return class_1269.field_5811;
        }

        class_2338 ovenKey = clickedPos.method_10062();

        // Load recipes before trying to activate
        IndustrialOvenRecipes.loadRecipes();

        // Try to match recipe from nearby chest
        class_2338 chestPos = clickedPos.method_10093(player.method_5735().method_10153());
        class_2680 chestState = world.method_8320(chestPos);

        if (!chestState.method_27852(class_2246.field_10034)) {
            player.method_7353(class_2561.method_43470("You need a chest behind the oven!"), true);
            return class_1269.field_5811;
        }

        class_2595 chest = (class_2595) world.method_8321(chestPos);
        if (chest == null) {
            player.method_7353(class_2561.method_43470("Chest not found!"), true);
            return class_1269.field_5811;
        }

        // Recipe eşleşmesi:
        IndustrialOvenRecipes.loadRecipes();

        RecipeData recipe = IndustrialOvenRecipes.matchRecipe(chest);
        if (recipe == null) {
            spawnParticles((class_3218) world, chestPos, false, 40, 3);
            world.method_8396(null, clickedPos, class_3417.field_15102, class_3419.field_15245, 1f, 1f);
            player.method_7353(class_2561.method_43470("No valid recipe found."), true);
            return class_1269.field_5812;
        }

// === recipeFileNameOrId'i otomatik bul ===
        String recipeFileNameOrId = null;
        for (Map.Entry<String, RecipeData> entry : IndustrialOvenRecipes.getAllRecipes().entrySet()) {
            if (entry.getValue() == recipe) {
                recipeFileNameOrId = entry.getKey(); // örn. "iron_to_golden_apple.json"
                break;
            }
        }
        if (recipeFileNameOrId == null) recipeFileNameOrId = "unknown_recipe";

// Fırını başlat
        if (!ovenData.activate(ovenKey.method_23854(), recipeFileNameOrId, recipe.time)) {
            player.method_7353(class_2561.method_43470("This oven is already running."), true);
            return class_1269.field_5812;
        }
        AutoConfig.getConfigHolder(OvenData.class).save();


        class_3218 serverWorld = (class_3218) world;

        // Validate oven structure
        if (!isStructureValid(serverWorld, clickedPos, chestPos)) {
            ovenData.deactivate(ovenKey.method_23854());
            AutoConfig.getConfigHolder(OvenData.class).save();
            return class_1269.field_5811;
        }

        // Start sound and visual effects
        world.method_8396(null, clickedPos, class_3417.field_17605, class_3419.field_15245, 1f, 1f);
        int duration = recipe.time;

        // Periodic fire particles
        for (int i = 0; i < duration; i += 5) {
            int delay = i;
            ServerScheduler.schedule(delay, () ->
                    spawnParticles(serverWorld, clickedPos, true, 20, 5)
            );
        }

        try {
            // Process completion
            ServerScheduler.schedule(duration, () -> {
                boolean hasSpace = false;
                for (int i = 0; i < chest.method_5439(); i++) {
                    if (chest.method_5438(i).method_7960()) {
                        hasSpace = true;
                        break;
                    }
                }

                if (!hasSpace) {
                    spawnParticles(serverWorld, chestPos, false, 40, 3);
                    world.method_8396(null, clickedPos, class_3417.field_14624.comp_349(), class_3419.field_15245, 1f, 0.8f);
                    player.method_7353(class_2561.method_43470("The oven did not run because the chest is full!"), true);
                    ovenData.deactivate(ovenKey.method_23854());
                    AutoConfig.getConfigHolder(OvenData.class).save();
                    return;
                }

                // Consume inputs
                for (var input : recipe.inputs) {
                    class_1792 item = net.minecraft.class_7923.field_41178.method_10223(class_2960.method_60654(input.item));
                    int remaining = input.count;

                    for (int i = 0; i < chest.method_5439(); i++) {
                        class_1799 stack = chest.method_5438(i);
                        if (stack.method_31574(item)) {
                            int remove = Math.min(remaining, stack.method_7947());
                            stack.method_7934(remove);
                            remaining -= remove;
                            if (remaining <= 0) break;
                        }
                    }
                }

                // Add result
                class_1799 result = IndustrialOvenRecipes.getOutput(recipe);
                boolean added = false;

                for (int i = 0; i < chest.method_5439(); i++) {
                    class_1799 stack = chest.method_5438(i);
                    if (canCombine(stack, result)) {
                        int transferable = Math.min(stack.method_7914() - stack.method_7947(), result.method_7947());
                        if (transferable > 0) {
                            stack.method_7933(transferable);
                            result.method_7934(transferable);
                            if (result.method_7960()) {
                                added = true;
                                break;
                            }
                        }
                    }
                }

                if (!added && !result.method_7960()) {
                    for (int i = 0; i < chest.method_5439(); i++) {
                        if (chest.method_5438(i).method_7960()) {
                            chest.method_5447(i, result.method_7972());
                            result.method_7934(result.method_7947());
                            added = true;
                            break;
                        }
                    }
                }

                if (!added && !result.method_7960()) {
                    class_1542 drop = new class_1542(world,
                            chestPos.method_10263() + 0.5,
                            chestPos.method_10264() + 1.0,
                            chestPos.method_10260() + 0.5,
                            result);
                    world.method_8649(drop);
                    player.method_7353(class_2561.method_43470("The chest was full, product dropped on the ground."), true);
                }

                chest.method_5431();
                spawnParticles(serverWorld, clickedPos, false, 50, 6);
                world.method_8396(null, clickedPos, class_3417.field_14627, class_3419.field_15245, 1f, 1.2f);
                ovenData.deactivate(ovenKey.method_23854());
                AutoConfig.getConfigHolder(OvenData.class).save();
            });
        } catch (Exception e) {
            ovenData.deactivate(ovenKey.method_23854());
            AutoConfig.getConfigHolder(OvenData.class).save();
            e.printStackTrace();
        }

        return class_1269.field_5812;
    }

    private static boolean isStructureValid(class_3218 world, class_2338 headPos, class_2338 chestPos) {
        for (class_2350 dir : class_2350.values()) {
            class_2338 checkPos = headPos.method_10093(dir);
            if (checkPos.equals(chestPos)) continue;
            class_2680 checkState = world.method_8320(checkPos);
            if (!checkState.method_27852(BlockType.INDUSTRIAL_OVEN_BLOCK)) {
                return false;
            }
        }
        return true;
    }

    private static boolean canCombine(class_1799 a, class_1799 b) {
        return !a.method_7960() && !b.method_7960() && a.method_31574(b.method_7909()) && class_1799.method_7973(a, b);
    }

    public static void finishProcess(class_3218 world, class_2338 ovenPos, IndustrialOvenRecipes.RecipeData recipe) {
        // Fırınla bağlantılı sandığı bul
        for (class_2350 dir : class_2350.values()) {
            class_2338 chestPos = ovenPos.method_10093(dir);
            class_2680 state = world.method_8320(chestPos);
            if (state.method_27852(class_2246.field_10034)) {
                class_2595 chest = (class_2595) world.method_8321(chestPos);
                if (chest == null) return;

                boolean hasSpace = false;
                for (int i = 0; i < chest.method_5439(); i++) {
                    if (chest.method_5438(i).method_7960()) {
                        hasSpace = true;
                        break;
                    }
                }
                if (!hasSpace) {
                    spawnParticles(world, chestPos, false, 40, 3);
                    world.method_8396(null, ovenPos, class_3417.field_14624.comp_349(), class_3419.field_15245, 1f, 0.8f);
                    return;
                }

                // Inputları azalt
                for (var input : recipe.inputs) {
                    class_1792 item = net.minecraft.class_7923.field_41178.method_10223(class_2960.method_60654(input.item));
                    int remaining = input.count;

                    for (int i = 0; i < chest.method_5439(); i++) {
                        class_1799 stack = chest.method_5438(i);
                        if (stack.method_31574(item)) {
                            int remove = Math.min(remaining, stack.method_7947());
                            stack.method_7934(remove);
                            remaining -= remove;
                            if (remaining <= 0) break;
                        }
                    }
                }

                // Output ekle
                class_1799 result = IndustrialOvenRecipes.getOutput(recipe);
                boolean added = false;

                for (int i = 0; i < chest.method_5439(); i++) {
                    class_1799 stack = chest.method_5438(i);
                    if (canCombine(stack, result)) {
                        int transferable = Math.min(stack.method_7914() - stack.method_7947(), result.method_7947());
                        if (transferable > 0) {
                            stack.method_7933(transferable);
                            result.method_7934(transferable);
                            if (result.method_7960()) {
                                added = true;
                                break;
                            }
                        }
                    }
                }

                if (!added && !result.method_7960()) {
                    for (int i = 0; i < chest.method_5439(); i++) {
                        if (chest.method_5438(i).method_7960()) {
                            chest.method_5447(i, result.method_7972());
                            result.method_7934(result.method_7947());
                            added = true;
                            break;
                        }
                    }
                }

                if (!added && !result.method_7960()) {
                    class_1542 drop = new class_1542(world,
                            chestPos.method_10263() + 0.5,
                            chestPos.method_10264() + 1.0,
                            chestPos.method_10260() + 0.5,
                            result);
                    world.method_8649(drop);
                }

                chest.method_5431();
                spawnParticles(world, ovenPos, false, 50, 6);
                world.method_8396(null, ovenPos, class_3417.field_14627, class_3419.field_15245, 1f, 1.2f);
                return;
            }
        }
    }


    private static void spawnParticles(class_3218 world, class_2338 pos, boolean fire, int count, double spread) {
        var type = fire ? class_2398.field_11240 : class_2398.field_11251;
        for (int i = 0; i < count; i++) {
            double x = pos.method_10263() + 0.5 + (Math.random() - 0.5) * spread;
            double y = pos.method_10264() + 0.5 + (Math.random() - 0.5) * spread;
            double z = pos.method_10260() + 0.5 + (Math.random() - 0.5) * spread;
            world.method_14199(type, x, y, z, 40, 0.1, 0.1, 0.1, 0.02);
        }
    }
}
