package mc.garakrral.event.totem.machine.recipe;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.*;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class IndustrialOvenRecipes {
    private static final Gson GSON = new Gson();
    private static final Map<String, RecipeData> RECIPES = new HashMap<>();

    public static class RecipeData {
        public int time;
        public List<Input> inputs;
        public Output output;
    }

    public static class Input {
        public String item;
        public int count;
    }

    public static class Output {
        public String item;
        public int count;
    }

    public static void loadRecipes() {
        RECIPES.clear();

        try {
            ClassLoader loader = IndustrialOvenRecipes.class.getClassLoader();
            // /data/mobpvp/totem_machine/industrial_oven içindeki dosyaları listele
            // Java ClassLoader doğrudan dizin listeleyemez, bu yüzden sabit liste veya resource tanımı gerekiyor
            // ama mod build edilirken bu dizin sabit olduğundan hepsi okunur
            String basePath = "data/mobpvp/totem_machine/industrial_oven/";
            String[] recipeFiles = {
                    "1.json",
                    "2.json",
                    "3.json",
                    "4.json",
                    "5.json",
                    "6.json",
                    "7.json",
                    "8.json",
                    "9.json",
                    "10.json",
                    "11.json",
            };

            for (String file : recipeFiles) {
                try (InputStream stream = loader.getResourceAsStream(basePath + file)) {
                    if (stream == null) {
                        continue;
                    }
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream))) {
                        RecipeData recipe = GSON.fromJson(reader, RecipeData.class);
                        RECIPES.put(file, recipe);
                    }
                }
            }

        } catch (Exception e) {

        }
    }

    public static RecipeData matchRecipe(net.minecraft.class_2595 chest) {
        List<class_1799> chestItems = new ArrayList<>();
        for (int i = 0; i < chest.method_5439(); i++) {
            chestItems.add(chest.method_5438(i));
        }

        for (RecipeData recipe : RECIPES.values()) {
            boolean matches = true;

            for (Input input : recipe.inputs) {
                class_1792 item = class_7923.field_41178.method_10223( class_2960.method_60654(input.item));
                int totalCount = 0;
                for (class_1799 stack : chestItems) {
                    if (stack.method_31574(item)) totalCount += stack.method_7947();
                }
                if (totalCount < input.count) {
                    matches = false;
                    break;
                }
            }

            if (matches) return recipe;
        }
        return null;
    }

    public static class_1799 getOutput(RecipeData recipe) {
        class_1792 item = class_7923.field_41178.method_10223(class_2960.method_60654(recipe.output.item));
        return new class_1799(item, recipe.output.count);
    }
    public static RecipeData getRecipeById(String id) {
        return RECIPES.get(id);
    }
    public static Map<String, RecipeData> getAllRecipes() {
        return RECIPES;
    }
}
