package mc.garakrral.gen;

import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_3031;
import net.minecraft.class_3773;
import net.minecraft.class_5321;
import net.minecraft.class_6796;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import net.minecraft.class_7151;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import mc.garakrral.build.ArenaFeature;
import mc.garakrral.gen.piece.BigPvETowerPiece;
import mc.garakrral.gen.piece.HousePiece;
import mc.garakrral.gen.piece.PvETowerPiece;
import mc.garakrral.gen.piece.StatuePiece;
import mc.garakrral.gen.piece.TallPvETowerPiece;
import mc.garakrral.gen.piece.VillagePiece;
import mc.garakrral.gen.piece.WaterPondPiece;
import mc.garakrral.gen.structure.BigPvETower;
import mc.garakrral.gen.structure.House;
import mc.garakrral.gen.structure.PvETower;
import mc.garakrral.gen.structure.Statue;
import mc.garakrral.gen.structure.TallPvETower;
import mc.garakrral.gen.structure.Village;
import mc.garakrral.gen.structure.WaterPondStructure;

import static com.kaplanlib.util.path.Paths.MOBPVP;

public class WorldGen {

    // Arena
    public static final class_2960 ARENA_ID = class_2960.method_60655(MOBPVP, "arena_feature");
    public static final class_3031<?> ARENA_FEATURE = new ArenaFeature();
    public static final class_5321<class_6796> ARENA_PLACED_KEY = class_5321.method_29179(class_7924.field_41245, ARENA_ID);
    // Water Pond
    public static final class_2960 WATER_POND_ID = class_2960.method_60655(MOBPVP, "water_pond");
    public static final class_7151<WaterPondStructure> WATER_POND = () -> WaterPondStructure.CODEC;
    public static final class_3773 WATER_POND_PIECE = WaterPondPiece::new;
    //PVE TOWER
    public static final class_2960 PVE_TOWER_ID = class_2960.method_60655(MOBPVP, "pve_tower");
    public static final class_7151<PvETower> PVE_TOWER_POND = () -> PvETower.CODEC;
    public static final class_3773 PVE_TOWER_POND_PIECE = PvETowerPiece::new;
    //EV
    public static final class_3773 HOUSE_PIECE = HousePiece::new;
    //PVE TOWER
    public static final class_2960 HOUSE_ID = class_2960.method_60655(MOBPVP, "house");
    public static final class_7151<House> HOUSE_POND = () -> House.CODEC;
    public static final class_3773 HOUSE_POND_PIECE = HousePiece::new;
    //VILLAGE
    public static final class_2960 VILLAGE_ID = class_2960.method_60655(MOBPVP, "mini_village");
    public static final class_7151<Village> VILLAGE_POND = () -> Village.CODEC;
    public static final class_3773 VILLAGE_POND_PIECE = VillagePiece::new;
    //HEYKEL
    public static final class_2960 STATUE_ID = class_2960.method_60655(MOBPVP, "statue");
    public static final class_7151<Statue> STATUE_POND = () -> Statue.CODEC;
    public static final class_3773 STATUE_POND_PIECE = StatuePiece::new;
    //BÜYÜK PVE TOWER
    public static final class_2960 BIG_PVE_TOWER_ID = class_2960.method_60655(MOBPVP, "big_pve_tower");
    public static final class_7151<BigPvETower> BIG_PVE_TOWER_POND = () -> BigPvETower.CODEC;
    public static final class_3773 BIG_PVE_TOWER_PIECE = BigPvETowerPiece::new;
    //UZUN PVE KULESİ
    public static final class_2960 TALL_PVE_TOWER_ID = class_2960.method_60655(MOBPVP, "tall_pve_tower");
    public static final class_7151<TallPvETower> TALL_PVE_TOWER_POND = () -> TallPvETower.CODEC;
    public static final class_3773 TALL_PVE_TOWER_PIECE = TallPvETowerPiece::new;


    public static void register() {
        // Arena Feature kaydı
        class_2378.method_10230(class_7923.field_41144, ARENA_ID, ARENA_FEATURE);

        // Structure kaydı
        class_2378.method_10230(class_7923.field_41147, WATER_POND_ID, WATER_POND);
        class_2378.method_10230(class_7923.field_41146, WATER_POND_ID, WATER_POND_PIECE);
        class_2378.method_10230(class_7923.field_41147, PVE_TOWER_ID, PVE_TOWER_POND);
        class_2378.method_10230(class_7923.field_41146, PVE_TOWER_ID, PVE_TOWER_POND_PIECE);
        class_2378.method_10230(class_7923.field_41147, HOUSE_ID, HOUSE_POND);
        class_2378.method_10230(class_7923.field_41146, HOUSE_ID, HOUSE_POND_PIECE);
        class_2378.method_10230(class_7923.field_41147, VILLAGE_ID, VILLAGE_POND);
        class_2378.method_10230(class_7923.field_41146, VILLAGE_ID, VILLAGE_POND_PIECE);
        class_2378.method_10230(class_7923.field_41147, STATUE_ID, STATUE_POND);
        class_2378.method_10230(class_7923.field_41146, STATUE_ID, STATUE_POND_PIECE);
        class_2378.method_10230(class_7923.field_41147, BIG_PVE_TOWER_ID, BIG_PVE_TOWER_POND);
        class_2378.method_10230(class_7923.field_41146, BIG_PVE_TOWER_ID, BIG_PVE_TOWER_PIECE);
        class_2378.method_10230(class_7923.field_41147, TALL_PVE_TOWER_ID, TALL_PVE_TOWER_POND);
        class_2378.method_10230(class_7923.field_41146, TALL_PVE_TOWER_ID, TALL_PVE_TOWER_PIECE);

        BiomeModifications.addFeature(BiomeSelectors.foundInOverworld().and(context -> {
            class_6880<class_1959> biomeEntry = context.getBiomeRegistryEntry();
            return !biomeEntry.method_40220(class_6908.field_36509) && !biomeEntry.method_40220(class_6908.field_36511) && !biomeEntry.method_40220(class_6908.field_36510);
        }), class_2893.class_2895.field_13173, ARENA_PLACED_KEY);


    }
}
