package mc.garakrral.gen.piece;

import mc.garakrral.gen.WorldGen;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_6625;

public class PvETowerPiece extends class_3443 {
    private final class_2338 origin;

    public PvETowerPiece(class_2338 pos) {
        super(WorldGen.PVE_TOWER_POND_PIECE, 0, class_3341.method_34390(
                new class_2338(pos.method_10263() - 8, pos.method_10264() - 4, pos.method_10260() - 8),
                new class_2338(pos.method_10263() + 8, pos.method_10264() + 4, pos.method_10260() + 8)
        ));
        this.origin = pos;
        this.method_14926(null);
    }

    public PvETowerPiece(class_6625 context, class_2487 nbt) {
        super(WorldGen.PVE_TOWER_POND_PIECE, nbt);
        this.origin = new class_2338(nbt.method_10550("ox"), nbt.method_10550("oy"), nbt.method_10550("oz"));
    }

    @Override
    protected void method_14943(class_6625 context, class_2487 nbt) {
        nbt.method_10569("ox", origin.method_10263());
        nbt.method_10569("oy", origin.method_10264());
        nbt.method_10569("oz", origin.method_10260());
    }

    @Override
    public void method_14931(class_5281 world, net.minecraft.class_5138 accessor,
                         net.minecraft.class_2794 generator, class_5819 random,
                         class_3341 chunkBox, net.minecraft.class_1923 chunkPos, class_2338 pivot) {

        int floors = 5;
        int floorHeight = 6;
        int radius = 6;

        // --- TABAN ---
        for (int x = -radius; x <= radius; x++) {
            for (int z = -radius; z <= radius; z++) {
                class_2338 ground = origin.method_10069(x, -1, z);
                if (Math.sqrt(x * x + z * z) <= radius) {
                    world.method_8652(ground, class_2246.field_10056.method_9564(), 3);
                }
            }
        }

        // --- KATLAR ---
        class_2338 pos = null;
        for (int floor = 0; floor < floors; floor++) {
            int baseY = origin.method_10264() + floor * floorHeight;

            // Duvarlar
            for (int x = -radius; x <= radius; x++) {
                for (int z = -radius; z <= radius; z++) {
                    double dist = Math.sqrt(x * x + z * z);
                    pos = origin.method_10069(x, baseY, z);

                    if (dist >= radius - 0.5 && dist <= radius + 0.5) {
                        for (int y = 0; y < floorHeight; y++) {
                            class_2338 wall = pos.method_10086(y);
                            float r = random.method_43057();
                            if (r < 0.6f) {
                                world.method_8652(wall, class_2246.field_10056.method_9564(), 3);
                            } else if (r < 0.8f) {
                                world.method_8652(wall, class_2246.field_10065.method_9564(), 3);
                            } else {
                                world.method_8652(wall, class_2246.field_10416.method_9564(), 3);
                            }
                        }
                    }
                }
            }

            // Zemin
            for (int x = -radius + 1; x < radius; x++) {
                for (int z = -radius + 1; z < radius; z++) {
                    if (Math.sqrt(x * x + z * z) < radius - 1.5) {
                        world.method_8652(origin.method_10069(x, baseY, z), class_2246.field_10445.method_9564(), 3);
                    }
                }
            }

            // Spiral merdiven
            for (int step = 0; step < floorHeight; step++) {
                int angle = (floor * floorHeight + step) * 90 / 2; // spiral dönüş
                double rad = Math.toRadians(angle);
                int sx = (int) Math.round(Math.cos(rad) * (radius - 2));
                int sz = (int) Math.round(Math.sin(rad) * (radius - 2));
                class_2338 stairPos = origin.method_10069(sx, baseY + step, sz);
                world.method_8652(stairPos, class_2246.field_10392.method_9564(), 3);
            }

            // Spawner (kat ortası)
            class_2338 spawnerPos = origin.method_10069(0, baseY + 1, 0);
            world.method_8652(spawnerPos, class_2246.field_10260.method_9564(), 3);
            var be = world.method_8321(spawnerPos);
            if (be instanceof net.minecraft.class_2636 spawner) {
                var type = random.method_43056()
                        ? net.minecraft.class_1299.field_6051
                        : net.minecraft.class_1299.field_6137;

                // spawner'a entity türünü ayarla
                spawner.method_46408(type, world.method_8409());
            }


            // Sandık (duvara yakın)
            class_2338 chestPos = origin.method_10069((random.method_43056() ? radius - 2 : -(radius - 2)), baseY + 1, 0);
            world.method_8652(chestPos, class_2246.field_10034.method_9564(), 3);
            var chestBE = world.method_8321(chestPos);
            if (chestBE instanceof net.minecraft.class_2595 chest) {
                chest.method_54867(net.minecraft.class_39.field_356, random.method_43055());
            }

            // Kat tavanı
            for (int x = -radius; x <= radius; x++) {
                for (int z = -radius; z <= radius; z++) {
                    if (Math.sqrt(x * x + z * z) <= radius) {
                        world.method_8652(origin.method_10069(x, baseY + floorHeight, z), class_2246.field_10056.method_9564(), 3);
                    }
                }
            }
            ;
        }

        // --- EN ÜST KAT LOOT ---
        class_2338 bossChest = origin.method_10069(0, origin.method_10264() + floors * floorHeight, 0);
        world.method_8652(bossChest, class_2246.field_10034.method_9564(), 3);
        var beBoss = world.method_8321(bossChest);
        if (beBoss instanceof net.minecraft.class_2595 chest) {
            chest.method_54867(net.minecraft.class_39.field_38438, random.method_43055());
        }

        // Çatı kubbe
        int topY = origin.method_10264() + floors * floorHeight;
        for (int y = 0; y < 4; y++) {
            for (int x = -radius; x <= radius; x++) {
                for (int z = -radius; z <= radius; z++) {
                    double dist = Math.sqrt(x * x + z * z);
                    if (dist < radius - y) {
                        class_2338 roof = origin.method_10069(x, topY + y, z);
                        world.method_8652(roof, class_2246.field_10056.method_9564(), 3);
                    }
                }
            }
        }
        // Roket altı / gemi altı ekleme
        class_2338 baseCenter = pos.method_10087(1); // kulenin altı

// Ortadaki ana motor bloğu (örnek: demir blok)
        world.method_8652(baseCenter, class_2246.field_10085.method_9564(), 3);

// Çevresine ateş efektli bloklar (örnek: magma)
        for (int dx = -1; dx <= 1; dx++) {
            for (int dz = -1; dz <= 1; dz++) {
                if (Math.abs(dx) + Math.abs(dz) == 1) { // artı şeklinde
                    class_2338 flamePos = baseCenter.method_10069(dx, 0, dz);
                    world.method_8652(flamePos, class_2246.field_10092.method_9564(), 3);

                    // Altına alev efekti (fire block)
                    class_2338 firePos = flamePos.method_10074();
                    world.method_8652(firePos, class_2246.field_10036.method_9564(), 3);
                }
            }
        }


    }


}
