package mc.garakrral.gen.piece;

import mc.garakrral.gen.WorldGen;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2794;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_6625;

public class StatuePiece extends class_3443 {
    private final class_2338 origin;

    public StatuePiece(class_2338 pos) {
        super(WorldGen.STATUE_POND_PIECE, 0, class_3341.method_34390(
                new class_2338(pos.method_10263() - 8, pos.method_10264() - 4, pos.method_10260() - 8),
                new class_2338(pos.method_10263() + 8, pos.method_10264() + 4, pos.method_10260() + 8)
        ));
        this.origin = pos;
        this.method_14926(null);
    }

    public StatuePiece(class_6625 context, class_2487 nbt) {
        super(WorldGen.STATUE_POND_PIECE, nbt);
        this.origin = new class_2338(nbt.method_10550("ox"), nbt.method_10550("oy"), nbt.method_10550("oz"));
    }

    @Override
    protected void method_14943(class_6625 context, class_2487 nbt) {
        nbt.method_10569("ox", origin.method_10263());
        nbt.method_10569("oy", origin.method_10264());
        nbt.method_10569("oz", origin.method_10260());
    }

    @Override
    public void method_14931(class_5281 world, class_5138 accessor,
                         class_2794 generator, class_5819 random,
                         class_3341 chunkBox, class_1923 chunkPos, class_2338 pivot) {

        // 4 farklı heykel türü
        int type = random.method_43048(4);

        switch (type) {
            case 0 -> buildStatueHuman(world, pivot);
            case 1 -> buildStatueSword(world, pivot);
            case 2 -> buildStatueShield(world, pivot);
            case 3 -> buildStatueDragon(world, pivot);
        }
    }

// ----------------- Heykel fonksiyonları -----------------

    private void buildStatueHuman(class_5281 world, class_2338 pivot) {
        // Basit insan figürü 3x3 taban, 6 yükseklik
        for (int y = 0; y < 6; y++) {
            world.method_8652(pivot.method_10086(y), class_2246.field_10056.method_9564(), 3);
        }
        // Kollar
        world.method_8652(pivot.method_10069(1, 3, 0), class_2246.field_10056.method_9564(), 3);
        world.method_8652(pivot.method_10069(-1, 3, 0), class_2246.field_10056.method_9564(), 3);
    }

    private void buildStatueSword(class_5281 world, class_2338 pivot) {
        // Kılıç figürü 1x1 taban, 5 yükseklik
        for (int y = 0; y < 5; y++) {
            world.method_8652(pivot.method_10086(y), class_2246.field_10085.method_9564(), 3);
        }
        // Kılıç ucu
        world.method_8652(pivot.method_10086(5), class_2246.field_10205.method_9564(), 3);
    }

    private void buildStatueShield(class_5281 world, class_2338 pivot) {
        // Kalkan 3x3 taban, 4 yükseklik
        for (int x = -1; x <= 1; x++) {
            for (int y = 0; y < 4; y++) {
                for (int z = -1; z <= 1; z++) {
                    world.method_8652(pivot.method_10069(x, y, z), class_2246.field_10161.method_9564(), 3);
                }
            }
        }
        // Kalkan desenleri
        world.method_8652(pivot.method_10069(0, 2, 0), class_2246.field_10205.method_9564(), 3);
        world.method_8652(pivot.method_10069(0, 3, 0), class_2246.field_10314.method_9564(), 3);
    }

    private void buildStatueDragon(class_5281 world, class_2338 pivot) {
        // Ejderha başı 3x3 taban
        for (int x = -1; x <= 1; x++) {
            for (int z = -1; z <= 1; z++) {
                world.method_8652(pivot.method_10069(x, 4, z), class_2246.field_23869.method_9564(), 3);
            }
        }
        // Gövde 1x1, 4 yükseklik
        for (int y = 0; y < 4; y++) {
            world.method_8652(pivot.method_10086(y), class_2246.field_10010.method_9564(), 3);
        }
        // Kuyruk
        world.method_8652(pivot.method_10069(0, 2, -1), class_2246.field_10010.method_9564(), 3);
    }

}
