package mc.garakrral.item.feature;

import mc.garakrral.item.ItemType;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1322;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350.class_2351;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2743;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5134;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9424;
import net.minecraft.entity.*;
import java.util.List;
import java.util.function.Predicate;

public class MaceItem extends class_1792 {
    private final float attackDamage;
    private final float attackSpeed;
    private final float knockbackRange;
    private final float knockbackPower;

    public MaceItem(class_1793 settings, float attackDamage, float attackSpeed, float knockbackRange, float knockbackPower) {
        super(settings);
        this.attackDamage = attackDamage;
        this.attackSpeed = attackSpeed;
        this.knockbackRange = knockbackRange;
        this.knockbackPower = knockbackPower;
    }

    public class_9285 method_7844() {
        return class_9285.method_57480()
                .method_57487(class_5134.field_23721, new class_1322(field_8006, this.attackDamage, class_1322.class_1323.field_6328), class_9274.field_49217)
                .method_57487(class_5134.field_23723, new class_1322(field_8001, this.attackSpeed, class_1322.class_1323.field_6328), class_9274.field_49217)
                .method_57486();
    }

    public static class_9424 createToolComponent() {
        return new class_9424(List.of(), 1.0F, 2);
    }

    public boolean method_7885(class_2680 state, class_1937 world, class_2338 pos, class_1657 miner) {
        return !miner.method_7337();
    }

    public int method_7837() {
        return 15;
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        if (attacker instanceof class_3222 serverPlayer) {
            if (shouldDealAdditionalDamage(serverPlayer)) {
                class_3218 world = (class_3218) serverPlayer.method_37908();

                serverPlayer.method_60984(true);
                serverPlayer.method_18799(serverPlayer.method_18798().method_38499(class_2351.field_11052, 0.01));
                serverPlayer.field_13987.method_14364(new class_2743(serverPlayer));

                class_3414 sound = target.method_24828() ?
                        (serverPlayer.field_6017 > 5.0F ? class_3417.field_49924 : class_3417.field_49785) :
                        class_3417.field_49784;

                world.method_43128(null, serverPlayer.method_23317(), serverPlayer.method_23318(), serverPlayer.method_23321(), sound, serverPlayer.method_5634(), 1.0F, 1.0F);
                knockbackNearbyEntities(world, serverPlayer, target);
            }
        }
        return true;
    }

    public void method_59978(class_1799 stack, class_1309 target, class_1309 attacker) {
        stack.method_7970(1, attacker, class_1304.field_6173);
        if (shouldDealAdditionalDamage(attacker)) {
            attacker.method_38785();
        }
    }

    public boolean method_7878(class_1799 stack, class_1799 ingredient) {
        return ingredient.method_31574(ItemType.REINFORCED_COPPER_INGOT); // özelleştirilebilir
    }

    public float method_58403(class_1297 target, float baseAttackDamage, class_1282 damageSource) {
        class_1297 attackerEntity = damageSource.method_5526();
        if (attackerEntity instanceof class_1309 attacker && shouldDealAdditionalDamage(attacker)) {
            float fall = attacker.field_6017;
            float extra = (fall <= 3) ? (4 * fall) : (fall <= 8) ? (12 + 2 * (fall - 3)) : (22 + fall - 8);
            if (attacker.method_37908() instanceof class_3218 serverWorld) {
                return extra + class_1890.method_60160(serverWorld, attacker.method_59958(), target, damageSource, 0) * fall;
            }
            return extra;
        }
        return 0;
    }

    private void knockbackNearbyEntities(class_1937 world, class_1657 player, class_1297 attacked) {
        world.method_20290(2013, attacked.method_23312(), 750);
        world.method_8390(class_1309.class, attacked.method_5829().method_1014(knockbackRange), getKnockbackPredicate(player, attacked)).forEach(entity -> {
            class_243 offset = entity.method_19538().method_1020(attacked.method_19538());
            double knockback = getKnockback(player, entity, offset);
            class_243 motion = offset.method_1029().method_1021(knockback);
            if (knockback > 0) {
                entity.method_5762(motion.field_1352, knockbackPower, motion.field_1350);
                if (entity instanceof class_3222 serverEntity) {
                    serverEntity.field_13987.method_14364(new class_2743(serverEntity));
                }
            }
        });
    }

    private Predicate<class_1309> getKnockbackPredicate(class_1657 player, class_1297 attacked) {
        return entity -> {
            boolean valid = !entity.method_7325()
                    && entity != player
                    && entity != attacked
                    && !player.method_5722(entity)
                    && (!(entity instanceof class_1321 tame) || !tame.method_6181() || !player.method_5667().equals(tame.method_6139()))
                    && (!(entity instanceof class_1531 armor) || !armor.method_6912())
                    && attacked.method_5858(entity) <= knockbackRange * knockbackRange;
            return valid;
        };
    }

    private double getKnockback(class_1657 player, class_1309 attacked, class_243 distance) {
        return (knockbackRange - distance.method_1033()) * knockbackPower *
                (player.field_6017 > 5 ? 2 : 1) *
                (1.0 - attacked.method_45325(class_5134.field_23718));
    }

    public static boolean shouldDealAdditionalDamage(class_1309 attacker) {
        return attacker.field_6017 > 1.5F && !attacker.method_6128();
    }
}
