package mc.garakrral.level;

import mc.garakrral.data.LevelData;

import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.class_1309;
import net.minecraft.class_7923;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LevelAssigner {

    private static final Pattern NAME_PATTERN = Pattern.compile("§c\\[Level: \\d+] §f(.+) §7- .*");

    private static LevelData getData() {
        return AutoConfig.getConfigHolder(LevelData.class).getConfig();
    }

    public static void assignLevel(class_1309 entity, String mobId, int level) {
        getData().setLevel(entity.method_5667(), level);
        AutoConfig.getConfigHolder(LevelData.class).save();
    }

    public static boolean hasLevel(class_1309 entity) {
        return getData().hasLevel(entity.method_5667());
    }

    public static int getLevel(class_1309 entity) {
        return getData().getLevel(entity.method_5667());
    }

    public static String getMobId(class_1309 entity) {
        return class_7923.field_41177.method_10221(entity.method_5864()).method_12832();
    }

    public static String getDefaultTranslatedName(class_1309 entity) {
        return entity.method_5864().method_5897().getString();
    }

    public static String extractBaseName(String formatted) {
        Matcher m = NAME_PATTERN.matcher(formatted);
        if (m.matches()) {
            return m.group(1);
        }
        return null;
    }

    public static String buildDisplayName(class_1309 entity) {
        int level = getLevel(entity);
        float currentHealth = entity.method_6032();
        float maxHealth = entity.method_6063();

        String baseName;

        if (entity.method_16914() && entity.method_5797() != null) {
            String rawName = entity.method_5797().getString();

            if (rawName.startsWith("§c[Level:")) {
                // Bizim format → orijinal ismi çek
                String extracted = extractBaseName(rawName);
                baseName = (extracted != null) ? extracted : getDefaultTranslatedName(entity);
            } else {
                // Oyuncu kendi özel ismini vermiş
                baseName = rawName;
            }
        } else {
            // Default isim Minecraft'ın dil sisteminden gelir
            baseName = getDefaultTranslatedName(entity);
        }

        return String.format(
                "§c[Level: %d] §f%s §7- §a%.1f§7/§c%.0f ❤",
                level,
                baseName,
                currentHealth,
                maxHealth
        );
    }
}
