package mc.garakrral.mixin.client;

import mc.garakrral.client.config.ConfigManager;

import me.shedaniel.autoconfig.AutoConfig;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_751;
import net.minecraft.class_766;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_766.class)
public class PanoramaMixin {

    @Mutable
    @Shadow @Final
    private class_751 cubeMap;

    private boolean addon$lastState = false;

    private static final class_2960 VANILLA_PANORAMA =
            class_2960.method_60656("textures/gui/title/background/panorama");
    private static final class_2960 MOBPVP_PANORAMA =
            class_2960.method_60655("mobpvp", "textures/gui/title/panorama");

    @Inject(method = "render", at = @At("HEAD"))
    private void addon$onRender(class_332 context, int width, int height, float alpha, float tickDelta, CallbackInfo ci) {
        ConfigManager config = AutoConfig.getConfigHolder(ConfigManager.class).getConfig();
        boolean enabled = config.showMobPvPPanorama;

        if (enabled != addon$lastState) {
            this.cubeMap = new class_751(enabled ? MOBPVP_PANORAMA : VANILLA_PANORAMA);
            addon$lastState = enabled;
        }
    }
}
