package mc.garakrral;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.loot.v2.LootTableEvents;
import net.fabricmc.fabric.api.loot.v2.LootTableSource;
import net.minecraft.class_1309;
import net.minecraft.class_1560;
import net.minecraft.class_1642;
import net.minecraft.class_1937;
import net.minecraft.class_219;
import net.minecraft.class_2378;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_44;
import net.minecraft.class_5134;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_7923;
import mc.garakrral.block.Blocks;
import mc.garakrral.command.CommandManager;
import mc.garakrral.effect.LevelEffectHandler;
import mc.garakrral.enchantment.EnchantmentGet;
import mc.garakrral.enchantment.EnchantmentsAndEffects;
import mc.garakrral.enchantment.effect.MagmatizationEffect;
import mc.garakrral.entity.EntityRegister;
import mc.garakrral.entity.boss.BulwarkEntity;
import mc.garakrral.event.Events;
import mc.garakrral.event.level.player.PlayerLevelEvents;
import mc.garakrral.gen.WorldGen;
import mc.garakrral.item.ItemType;
import mc.garakrral.item.Items;
import mc.garakrral.item.group.ItemGroups;
import mc.garakrral.level.BossVariants;
import mc.garakrral.level.LevelAssigner;
import mc.garakrral.level.MobLevelRegistry;
import mc.garakrral.level.player.PlayerLevelData;
import mc.garakrral.level.player.PlayerLevelSaveHandler;
import mc.garakrral.registry.DataRegister;
import mc.garakrral.registry.HandlerRegister;
import mc.garakrral.sound.Sounds;
import mc.garakrral.trade.Trades;
import mc.garakrral.villager.Villagers;
import mc.garakrral.xpjump.network.XpJumpServer;

import com.kaplanlib.api.PluginRegistry;
import com.kaplanlib.api.annotation.KaplanBedwars;

import static com.kaplanlib.util.path.Paths.MOBPVP;
import static com.kaplanlib.util.path.Paths.STARTUP_SOUND_EVENT;
import static com.kaplanlib.util.path.Paths.STARTUP_SOUND_ID;


@KaplanBedwars
public final class mobpvp implements ModInitializer {

    public static final Map<String, Integer[]> LEVEL_RANGES = new HashMap<>();
    public static final String MOD_ID = MOBPVP;
    public static final String MODID = MOBPVP;

    @Override
    public void onInitialize() {
        XpJumpServer.register();
        DataRegister.registerAllData();
        HandlerRegister.registerHandlers();
        Sounds.touch();
        EnchantmentsAndEffects.registerModEnchantmentEffects();
        EnchantmentGet.init();
        WorldGen.register();
        Blocks.init();
        Villagers.registerVillagers();
        Trades.init();
        EntityRegister.register();
        Items.init();
        ItemGroups.init();
        class_2378.method_10230(class_7923.field_41172, STARTUP_SOUND_ID, STARTUP_SOUND_EVENT);
        PluginRegistry.callOnLoad();
        Events.register();
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            CommandManager.register(dispatcher);
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            Trades.register(); // enchantment registry bu noktada hazır
            PlayerLevelSaveHandler.init(server);
        });

        ServerLifecycleEvents.SERVER_STOPPING.register(server -> PlayerLevelSaveHandler.save());
        ServerTickEvents.END_WORLD_TICK.register(world -> {
            MagmatizationEffect.tick(world);
            for (var player : world.method_18456()) {
                UUID uuid = player.method_5667();
                int level = PlayerLevelData.getLevel(uuid);
                PlayerLevelEvents.applyStatBonus(player, level);
            }
        });


        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> {
            if (!(entity instanceof class_1309 living) || entity instanceof class_3222 || entity instanceof BulwarkEntity)
                return;
            if (living.method_16914()) return;


            String mobId = class_7923.field_41177.method_10221(entity.method_5864()).method_12832();
            Integer[] range = MobLevelRegistry.getLevelRangeOrDefault(mobId, new Integer[]{1, 40});
            int level = range[0] + entity.method_59922().method_43048(range[1] - range[0] + 1);


            LevelAssigner.assignLevel(living, mobId, level);


            if (entity instanceof class_1642 zombie) {
                if (BossVariants.tryAssignCustomZombieBoss(zombie, living, world)) return;
            }

            if (living.method_5996(class_5134.field_23716) != null) {
                double base = living.method_5996(class_5134.field_23716).method_6201();
                double extra = Math.log(level + 1) * 10; // Daha dengeli
                double total = base + extra;
                living.method_5996(class_5134.field_23716).method_6192(total);
                living.method_6033((float) total);
            }


            if (living.method_5996(class_5134.field_23721) != null) {
                double dmg = living.method_5996(class_5134.field_23721).method_6201();
                living.method_5996(class_5134.field_23721).method_6192(dmg + level * 0.3);
            }

            LevelEffectHandler.applyEffects(living, level);


            if (entity instanceof class_1560 enderman && level > 8) {
                List<class_3222> players = ((class_3218) entity.method_37908()).method_18456();
                if (!players.isEmpty()) {
                    class_3222 nearest = players.stream().min(Comparator.comparingDouble(p -> p.method_5858(entity))).orElse(null);
                    if (nearest != null) enderman.method_5980(nearest);
                }
            }

            if (entity instanceof class_1642 zombie && zombie.method_59922().method_43057() < 0.05f) {
                class_1309 finalEntity = zombie;
                new Thread(() -> {
                    try {
                        Thread.sleep(3000);

                        // Minecraft ana thread’ine güvenli şekilde iş teslimi
                        if (!finalEntity.method_31481() && finalEntity.method_37908() instanceof class_3218 serverWorld) {
                            serverWorld.method_8503().execute(() -> {
                                serverWorld.method_8437(finalEntity, finalEntity.method_23317(), finalEntity.method_23318(), finalEntity.method_23321(), 2.5f, class_1937.class_7867.field_40890);
                                finalEntity.method_31472();
                            });
                        }
                    } catch (InterruptedException ignored) {
                    }
                }).start();

            }
        });

        LootTableEvents.MODIFY.register((class_5321<class_52> id, class_52.class_53 builder, LootTableSource source) -> {
            if (!"minecraft".equals(id.method_29177().method_12836())) return;
            if (!id.method_29177().method_12832().startsWith("entities/")) return;
            String mobId = id.method_29177().method_12832().replace("entities/", "");
            Integer[] range = LEVEL_RANGES.getOrDefault(mobId, new Integer[]{1, 1});
            int level = range[1];
            List<class_79> common = new ArrayList<>();
            List<class_79> rare = new ArrayList<>();
            List<class_79> guaranteed = new ArrayList<>();
            List<class_79> veryCommon = new ArrayList<>();

            if (!mobId.equals("sheep") && !mobId.equals("cow") && !mobId.equals("chicken") && !mobId.equals("pig")) {
                if (level >= 2) common.add(class_77.method_411(net.minecraft.class_1802.field_8620).method_419());
                if (level >= 4) common.add(class_77.method_411(net.minecraft.class_1802.field_8102).method_419());
                if (level >= 6) common.add(class_77.method_411(net.minecraft.class_1802.field_8695).method_419());
                if (level >= 10) common.add(class_77.method_411(net.minecraft.class_1802.field_8477).method_419());
                if (level >= 15) common.add(class_77.method_411(net.minecraft.class_1802.field_8058).method_419());
                if (level >= 50) common.add(class_77.method_411(net.minecraft.class_1802.field_22021).method_419());

                if (level >= 10) {
                    rare.add(class_77.method_411(net.minecraft.class_1802.field_8367).method_419());
                    rare.add(class_77.method_411(net.minecraft.class_1802.field_22020).method_419());
                    rare.add(class_77.method_411(net.minecraft.class_1802.field_8288).method_419());
                }
                if (level >= 100) {
                    rare.add(class_77.method_411(net.minecraft.class_1802.field_8137).method_419());
                    rare.add(class_77.method_411(net.minecraft.class_1802.field_22028).method_419());
                }
                if (level >= 200) {
                    rare.add(class_77.method_411(net.minecraft.class_1802.field_22022).method_419());
                    rare.add(class_77.method_411(net.minecraft.class_1802.field_28101).method_419());
                }

                if (level == 1000) {
                    guaranteed.add(class_77.method_411(net.minecraft.class_1802.field_22025).method_419());
                    guaranteed.add(class_77.method_411(net.minecraft.class_1802.field_22020).method_419());
                    guaranteed.add(class_77.method_411(net.minecraft.class_1802.field_22028).method_419());
                    guaranteed.add(class_77.method_411(net.minecraft.class_1802.field_22022).method_419());
                }
                if (mobId.equals("ender_dragon")) {
                    guaranteed.add(class_77.method_411(net.minecraft.class_1802.field_8840).method_419());
                    guaranteed.add(class_77.method_411(net.minecraft.class_1802.field_8833).method_419());
                    guaranteed.add(class_77.method_411(net.minecraft.class_1802.field_22018).method_419());
                    guaranteed.add(class_77.method_411(net.minecraft.class_1802.field_8668).method_419());
                }
                if (mobId.equals("zombie")) {
                    rare.add(class_77.method_411(ItemType.KALP_ITEM).method_419());
                    guaranteed.add(class_77.method_411(ItemType.HEARTH_PART).method_419());
                }
                if (mobId.equals("warden")) {
                    guaranteed.add(class_77.method_411(net.minecraft.class_1802.field_37538).method_419());
                    guaranteed.add(class_77.method_411(net.minecraft.class_1802.field_22020).method_419());
                    guaranteed.add(class_77.method_411(net.minecraft.class_1802.field_22025).method_419());
                    guaranteed.add(class_77.method_411(net.minecraft.class_1802.field_22030).method_419());
                }

                veryCommon.add(class_77.method_411(net.minecraft.class_1802.field_8675).method_419());
                veryCommon.add(class_77.method_411(net.minecraft.class_1802.field_8397).method_419());
                veryCommon.add(class_77.method_411(net.minecraft.class_1802.field_8054).method_419());
            } else {
                if (mobId.equals("sheep"))
                    common.add(class_77.method_411(net.minecraft.class_1802.field_8347).method_419());
                if (mobId.equals("cow")) common.add(class_77.method_411(net.minecraft.class_1802.field_8176).method_419());
                if (mobId.equals("pig"))
                    common.add(class_77.method_411(net.minecraft.class_1802.field_8261).method_419());
                if (mobId.equals("chicken"))
                    common.add(class_77.method_411(net.minecraft.class_1802.field_8544).method_419());
            }

            if (!guaranteed.isEmpty()) {
                class_55.class_56 gpool = class_55.method_347().method_352(class_44.method_32448(guaranteed.size()));
                guaranteed.forEach(gpool::with);
                builder.method_336(gpool);
            }

            if (!common.isEmpty()) {
                class_55.class_56 pool = class_55.method_347().method_352(class_44.method_32448(2)).method_356(class_219.method_932(Math.min(0.75f, level * 0.015f)));
                common.forEach(pool::with);
                builder.method_336(pool);
            }

            if (!rare.isEmpty()) {
                class_55.class_56 rarePool = class_55.method_347().method_352(class_44.method_32448(2)).method_356(class_219.method_932(Math.min(0.35f, level * 0.01f)));
                rare.forEach(rarePool::with);
                builder.method_336(rarePool);
            }

            if (!veryCommon.isEmpty()) {
                class_55.class_56 vcPool = class_55.method_347().method_352(class_44.method_32448(1)).method_356(class_219.method_932(0.7f));
                veryCommon.forEach(vcPool::with);
                builder.method_336(vcPool);
            }
        });
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            PluginRegistry.callOnClose();
            System.out.println("[MobPVP] Mod kapanıyor...");
        }));
    }

    private static String cap(String s) {
        return s.isEmpty() ? s : s.substring(0, 1).toUpperCase(Locale.ROOT) + s.substring(1);
    }
}