package mc.garakrral.trade;

import java.util.Optional;

import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.object.builder.v1.trade.TradeOfferHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1772;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1893;
import net.minecraft.class_1914;
import net.minecraft.class_2960;
import net.minecraft.class_3852;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import net.minecraft.class_9306;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import mc.garakrral.enchantment.EnchantmentGet;
import mc.garakrral.enchantment.list.EnchantmentList;
import mc.garakrral.villager.Villagers;

import static mc.garakrral.mobpvp.MOD_ID;

public class Trades {

    private static class_7871<class_1887> ENCHANTMENT_REG;

    public static void init() {
        // server başladığında enchantment registry'yi kaydet
        ServerLifecycleEvents.SERVER_STARTING.register(Trades::onServerStarting);
    }

    public static void register() {
        // Lookup kaynağını kaydet (server başlarken world registryden alınacak)


        TradeOfferHelper.registerVillagerOffers(
                class_3852.field_17060,
                1,
                factories -> factories.add(Trades::create)
        );

        reg(1, new class_1914(pay(class_1802.field_8687, 1), out(class_1802.field_8229, 6), 24, 1, 0.02f));
        reg(1, new class_1914(pay(class_1802.field_8687, 4), out(class_1802.field_8810, 16), 24, 1, 0.02f));
        reg(1, new class_1914(pay(class_1802.field_8687, 1), out(class_1802.field_8745, 4), 20, 2, 0.03f));
        reg(1, new class_1914(pay(class_1802.field_8687, 4), out(class_1802.field_8713, 8), 20, 2, 0.03f));
        reg(1, new class_1914(pay(class_1802.field_8687, 2), out(class_1802.field_8600, 16), 18, 2, 0.04f));
        reg(1, new class_1914(pay(class_1802.field_8687, 2), out(class_1802.field_8107, 16), 18, 3, 0.04f));
        reg2(1, pay(class_1802.field_8687, 1), pay(class_1802.field_8145, 2), out(class_1802.field_8276, 8), 16, 3, 0.05f);
        reg(1, new class_1914(pay(class_1802.field_8687, 8), out(class_1802.field_20417, 2), 14, 3, 0.05f));
        reg(1, new class_1914(pay(class_1802.field_8687, 2), out(class_1802.field_8777, 2), 12, 4, 0.06f));
        reg2(1, pay(class_1802.field_8687, 10), pay(class_1802.field_8620, 4), out(class_1802.field_8725, 8), 12, 4, 0.06f);
        reg(2, new class_1914(pay(class_1802.field_8687, 8), out(class_1802.field_8155, 8), 12, 4, 0.07f));
        reg2(2, pay(class_1802.field_8687, 3), pay(class_1802.field_8601, 2), out(class_1802.field_8281, 2), 8, 5, 0.08f);

        reg(2, new class_1914(pay(class_1802.field_8687, 40), out(class_1802.field_8634, 1), 2, 6, 0.10f));
        reg2(2, pay(class_1802.field_8687, 4), pay(class_1802.field_8183, 1), out(class_1802.field_8894, 1), 6, 7, 0.11f);
        reg(2, new class_1914(pay(class_1802.field_8687, 12), out(class_1802.field_8135, 2), 6, 7, 0.11f));
        reg2(2, pay(class_1802.field_8687, 8), pay(class_1802.field_8054, 4), out(class_1802.field_8639, 4), 8, 7, 0.12f);

        reg(2, new class_1914(pay(class_1802.field_8687, 4), out(class_1802.field_8864, 1), 5, 8, 0.13f));
        reg2(2, pay(class_1802.field_8687, 4), pay(class_1802.field_8680, 2), out(class_1802.field_8711, 2), 6, 8, 0.13f);
        reg(2, new class_1914(pay(class_1802.field_8687, 8), out(class_1802.field_8070, 1), 4, 9, 0.15f));
        reg2(2, pay(class_1802.field_8687, 4), pay(class_1802.field_8695, 2), out(class_1802.field_8597, 2), 6, 9, 0.15f);

        reg(3, new class_1914(pay(class_1802.field_8687, 45), out(class_1802.field_8614, 1), 4, 10, 0.16f));
        reg2(3, pay(class_1802.field_8687, 5), pay(class_1802.field_8323, 1), out(class_1802.field_8161, 1), 3, 10, 0.17f);
        reg(3, new class_1914(pay(class_1802.field_8687, 8), out(class_1802.field_8175, 1), 3, 11, 0.18f));
        reg2(3, pay(class_1802.field_8687, 14), pay(class_1802.field_8366, 1), out(class_1802.field_8448, 1), 3, 11, 0.18f);

        reg(3, new class_1914(pay(class_1802.field_8477, 2), out(class_1802.field_8207, 1), 2, 14, 0.22f));
        reg2(3, pay(class_1802.field_8687, 12), pay(class_1802.field_23843, 1), out(class_1802.field_8226, 1), 40, 14, 0.20f);
        reg(3, new class_1914(pay(class_1802.field_8687, 19), out(class_1802.field_8740, 1), 5, 12, 0.19f));
        reg2(3, pay(class_1802.field_8687, 6), pay(class_1802.field_8281, 2), out(class_1802.field_8466, 1), 2, 16, 0.24f);

        reg(3, new class_1914(pay(class_1802.field_8477, 1), out(class_1802.field_8815, 1), 2, 16, 0.24f));
        reg2(3, pay(class_1802.field_8687, 7), pay(class_1802.field_8815, 1), out(class_1802.field_8545, 1), 2, 18, 0.26f);

        reg(4, new class_1914(pay(class_1802.field_8687, 17), out(class_1802.field_8287, 6), 3, 16, 0.22f));
        reg2(4, pay(class_1802.field_8687, 7), pay(class_1802.field_8407, 6), out(class_1802.field_8529, 6), 6, 14, 0.20f);

        reg(4, new class_1914(pay(class_1802.field_8687, 8), out(class_1802.field_8537, 2), 4, 16, 0.22f));
        reg2(4, pay(class_1802.field_8687, 8), pay(class_1802.field_8725, 8), out(class_1802.field_8357, 1), 3, 16, 0.22f);
        reg(4, new class_1914(pay(class_1802.field_8687, 8), out(class_1802.field_27019, 8), 4, 16, 0.22f));
        reg2(5, pay(class_1802.field_8687, 8), pay(class_1802.field_22421, 1), out(class_1802.field_23141, 1), 1, 20, 0.28f);

        reg(5, new class_1914(pay(class_1802.field_8687, 10), book(class_1893.field_9119, 2), 3, 20, 0.25f));
        reg2(5, pay(class_1802.field_8687, 12), pay(class_1802.field_8759, 8), book(class_1893.field_9131, 4), 2, 22, 0.28f);
        reg(5, new class_1914(pay(class_1802.field_8477, 1), book(EnchantmentGet.MAGMATIZATION, 4), 2, 24, 0.30f));
        reg(5, new class_1914(pay(class_1802.field_8477, 2), book(class_1893.field_9101, 1), 1, 30, 0.35f));
    }

    private static class_1914 create(class_1297 entity, class_5819 random) {
        if (random.method_43057() >= 0.01f) return null;

        class_1799 enchantedBook = new class_1799(class_1802.field_8598);
        var registry = entity.method_37908().method_30349().method_30530(class_7924.field_41265);

        String[] enchantments = EnchantmentList.getAllNames();
        String selectedEnchantment = enchantments[random.method_43048(enchantments.length)];

        class_5321<class_1887> key = class_5321.method_29179(class_7924.field_41265, class_2960.method_60655(MOD_ID, selectedEnchantment));
        class_6880<class_1887> entry = registry.method_40264(key).orElseThrow(
                () -> new IllegalStateException("Enchantment not found: " + key.method_29177())
        );

        class_9304.class_9305 builder = new class_9304.class_9305(class_9304.field_49385);
        builder.method_57550(entry, 1);
        enchantedBook.method_57379(class_9334.field_49643, builder.method_57549());

        class_9306 price = new class_9306(class_1802.field_8687, 20);

        return new class_1914(price, enchantedBook, 1, 2, 0.3f);
    }

    private static void onServerStarting(MinecraftServer server) {
        ENCHANTMENT_REG = server.method_30611().method_46762(class_7924.field_41265);
    }

    private static class_1799 book(class_5321<class_1887> key, int level) {
        if (ENCHANTMENT_REG == null) {
            throw new IllegalStateException("Enchantment registry not initialized yet!");
        }

        class_6880<class_1887> entry = ENCHANTMENT_REG.method_46746(key)
                .orElseThrow(() -> new IllegalStateException("Enchantment not found: " + key.method_29177()));

        return class_1772.method_7808(new class_1889(entry, level));
    }


    private static class_9306 pay(class_1792 item, int count) {
        return new class_9306(item, count);
    }

    private static class_1799 out(class_1792 item, int count) {
        return new class_1799(item, count);
    }

    private static void reg(int level, class_1914 offer) {
        TradeOfferHelper.registerVillagerOffers(Villagers.SECRET_TRADER, level, factories -> factories.add((entity, random) -> offer));
    }

    private static void reg(int level, class_9306 payment, class_1799 result, int uses, int xp, float priceMul) {
        TradeOfferHelper.registerVillagerOffers(Villagers.SECRET_TRADER, level, factories ->
                factories.add((entity, random) -> new class_1914(payment, Optional.empty(), result, uses, xp, priceMul)));
    }

    private static void reg2(int level, class_9306 firstPayment, class_9306 secondPayment, class_1799 result, int uses, int xp, float priceMul) {
        TradeOfferHelper.registerVillagerOffers(Villagers.SECRET_TRADER, level, factories ->
                factories.add((entity, random) -> new class_1914(firstPayment, Optional.of(secondPayment), result, uses, xp, priceMul)));
    }
}
