/*
 * Decompiled with CFR 0.152.
 */
package mc.garakrral.gen.piece;

import mc.garakrral.block.BlockType;
import mc.garakrral.gen.WorldGen;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_39;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_6625;

public class BigPvETowerPiece
extends class_3443 {
    private final class_2338 origin;

    public BigPvETowerPiece(class_2338 pos) {
        super(WorldGen.BIG_PVE_TOWER_PIECE, 0, class_3341.method_34390((class_2382)new class_2338(pos.method_10263() - 8, pos.method_10264() - 4, pos.method_10260() - 8), (class_2382)new class_2338(pos.method_10263() + 8, pos.method_10264() + 4, pos.method_10260() + 8)));
        this.origin = pos;
        this.method_14926(null);
    }

    public BigPvETowerPiece(class_6625 context, class_2487 nbt) {
        super(WorldGen.BIG_PVE_TOWER_PIECE, nbt);
        this.origin = new class_2338(nbt.method_10550("ox"), nbt.method_10550("oy"), nbt.method_10550("oz"));
    }

    protected void method_14943(class_6625 context, class_2487 nbt) {
        nbt.method_10569("ox", this.origin.method_10263());
        nbt.method_10569("oy", this.origin.method_10264());
        nbt.method_10569("oz", this.origin.method_10260());
    }

    public void method_14931(class_5281 world, class_5138 accessor, class_2794 generator, class_5819 random, class_3341 chunkBox, class_1923 chunkPos, class_2338 pivot) {
        int floors = 14;
        int floorHeight = 6;
        int radius = 12;
        boolean wallThickness = true;
        for (int x = -14; x <= 14; ++x) {
            for (int z = -14; z <= 14; ++z) {
                double dist = Math.hypot(x, z);
                class_2338 ground = this.origin.method_10069(x, -2, z);
                if (!(dist <= 13.25)) continue;
                class_2680 base = dist < 10.5 ? class_2246.field_10445.method_9564() : class_2246.field_10056.method_9564();
                world.method_8652(ground, base, 3);
            }
        }
        class_2338 centerLast = this.origin;
        for (int floor = 0; floor < 14; ++floor) {
            int x;
            int baseY = this.origin.method_10264() + floor * 6;
            for (x = -12; x <= 12; ++x) {
                for (int z = -12; z <= 12; ++z) {
                    double dist = Math.hypot(x, z);
                    if (!(dist >= 11.25) || !(dist <= 12.75)) continue;
                    for (int t = 0; t < 1; ++t) {
                        for (int y = 0; y < 6; ++y) {
                            class_2338 p = this.origin.method_10069(x * (1 + t), baseY + y, z * (1 + t));
                            class_2680 bs = BigPvETowerPiece.selectWallBlock(random);
                            world.method_8652(p, bs, 3);
                        }
                    }
                    if (floor % 2 != 0 || !(random.method_43057() < 0.18f)) continue;
                    BigPvETowerPiece.placeVerticalWindow(world, this.origin.method_10069(x, baseY + 1, z), Math.max(2, 3));
                }
            }
            for (x = -11; x <= 11; ++x) {
                for (int z = -11; z <= 11; ++z) {
                    if (!(Math.hypot(x, z) < 10.5)) continue;
                    class_2338 p = this.origin.method_10069(x, baseY, z);
                    class_2680 floorState = (Math.abs(x) + Math.abs(z)) % 6 == 0 ? class_2246.field_10093.method_9564() : class_2246.field_9989.method_9564();
                    world.method_8652(p, floorState, 3);
                }
            }
            BigPvETowerPiece.buildCentralCore(world, this.origin, baseY, 6, random);
            if (floor % 2 == 0) {
                class_2338 spawnerBase = this.origin.method_10069(0, baseY, 0);
                class_2338 spawnerPos = spawnerBase.method_10084();
                for (int x2 = -1; x2 <= 1; ++x2) {
                    for (int z = -1; z <= 1; ++z) {
                        class_2338 floorPos = spawnerBase.method_10069(x2, 0, z);
                        world.method_8652(floorPos, class_2246.field_10093.method_9564(), 3);
                    }
                }
                world.method_8652(spawnerPos, BlockType.PVP_SPAWNER.method_9564(), 3);
            }
            for (int i = 0; i < 2; ++i) {
                int dx = i == 0 ? 10 : -10;
                int dz = i == 0 ? 1 : -1;
                class_2338 chestPos = this.origin.method_10069(dx, baseY + 1, dz);
                world.method_8652(chestPos, class_2246.field_10034.method_9564(), 3);
                class_2586 be = world.method_8321(chestPos);
                if (!(be instanceof class_2595)) continue;
                class_2595 chest = (class_2595)be;
                chest.method_54867(i == 0 ? class_39.field_356 : class_39.field_251, random.method_43055());
            }
            BigPvETowerPiece.buildFloorBalconies(world, this.origin, baseY, 12, random);
            for (x = -12; x <= 12; ++x) {
                for (int z = -12; z <= 12; ++z) {
                    if (!(Math.hypot(x, z) <= 12.0)) continue;
                    world.method_8652(this.origin.method_10069(x, baseY + 6, z), class_2246.field_10056.method_9564(), 3);
                }
            }
            centerLast = this.origin.method_10069(0, baseY, 0);
        }
        class_2338 bossCenter = this.origin.method_10069(0, 86, 0);
        BigPvETowerPiece.buildBossRoom(world, bossCenter, 10, random);
        BigPvETowerPiece.buildGlassDome(world, this.origin, 14, 6, 12, random);
        BigPvETowerPiece.buildEntranceBridge(world, this.origin, 12, random);
        class_2338 baseCenter = centerLast.method_10087(2);
        world.method_8652(baseCenter, class_2246.field_10085.method_9564(), 3);
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                if (Math.abs(dx) + Math.abs(dz) != 1) continue;
                class_2338 magma = baseCenter.method_10069(dx, 0, dz);
                world.method_8652(magma, class_2246.field_10092.method_9564(), 3);
                world.method_8652(magma.method_10074(), class_2246.field_10036.method_9564(), 3);
            }
        }
        BigPvETowerPiece.addExteriorDecoration(world, this.origin, 12, random);
    }

    private static class_2680 selectWallBlock(class_5819 random) {
        float r = random.method_43057();
        if (r < 0.52f) {
            return class_2246.field_10056.method_9564();
        }
        if (r < 0.78f) {
            return class_2246.field_10065.method_9564();
        }
        if (r < 0.94f) {
            return class_2246.field_10416.method_9564();
        }
        return class_2246.field_10552.method_9564();
    }

    private static void placeVerticalWindow(class_5281 world, class_2338 start, int height) {
        for (int i = 0; i < height; ++i) {
            world.method_8652(start.method_10086(i), class_2246.field_10285.method_9564(), 3);
        }
    }

    private static void buildCentralCore(class_5281 world, class_2338 origin, int baseY, int floorHeight, class_5819 random) {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                for (int y = 0; y < floorHeight; ++y) {
                    class_2338 p = origin.method_10069(x, baseY + y, z);
                    if (x == 0 && z == 0) {
                        world.method_8652(p, class_2246.field_10382.method_9564(), 3);
                        continue;
                    }
                    world.method_8652(p, class_2246.field_10124.method_9564(), 3);
                }
            }
        }
        world.method_8652(origin.method_10069(0, baseY + floorHeight - 1, 0), class_2246.field_10463.method_9564(), 3);
        for (int step = 0; step < floorHeight; ++step) {
            int angle = (baseY + step) * 45;
            double rad = Math.toRadians(angle);
            int sx = (int)Math.round(Math.cos(rad) * 5.0);
            int sz = (int)Math.round(Math.sin(rad) * 5.0);
            class_2338 stairPos = origin.method_10069(sx, baseY + step, sz);
            world.method_8652(stairPos, class_2246.field_10392.method_9564(), 3);
            if (!(random.method_43057() < 0.45f)) continue;
            world.method_8652(stairPos.method_10084(), class_2246.field_10625.method_9564(), 3);
        }
    }

    private static void buildFloorBalconies(class_5281 world, class_2338 origin, int baseY, int radius, class_5819 random) {
        for (int side = 0; side < 4; ++side) {
            int dx;
            int n = side == 0 ? radius : (dx = side == 2 ? -radius : 0);
            int dz = side == 1 ? radius : (side == 3 ? -radius : 0);
            class_2338 b = origin.method_10069(dx, baseY + 2, dz);
            for (int x = -2; x <= 2; ++x) {
                for (int z = 0; z <= 2; ++z) {
                    class_2338 p = b.method_10069(x, 0, dz == 0 ? z : -z);
                    world.method_8652(p, class_2246.field_10161.method_9564(), 3);
                }
            }
            world.method_8652(b.method_10086(1), class_2246.field_16541.method_9564(), 3);
            if (!(random.method_43057() < 0.25f)) continue;
            world.method_8652(b.method_10069(0, 0, dz == 0 ? 3 : -3), class_2246.field_10151.method_9564(), 3);
        }
    }

    private static void buildBossRoom(class_5281 world, class_2338 center, int chamberRadius, class_5819 random) {
        int height = 6;
        for (int x = -chamberRadius; x <= chamberRadius; ++x) {
            for (int z = -chamberRadius; z <= chamberRadius; ++z) {
                double dist = Math.hypot(x, z);
                if (!(dist <= (double)chamberRadius + 0.2)) continue;
                for (int y = 0; y <= height; ++y) {
                    class_2338 p = center.method_10069(x, -y, z);
                    world.method_8652(p, class_2246.field_10056.method_9564(), 3);
                }
                class_2338 floor = center.method_10069(x, 0, z);
                if ((Math.abs(x) + Math.abs(z)) % 4 == 0) {
                    world.method_8652(floor, class_2246.field_23880.method_9564(), 3);
                    continue;
                }
                world.method_8652(floor, class_2246.field_23151.method_9564(), 3);
            }
        }
        class_2338 bossChest = center.method_10069(0, 1, 0);
        world.method_8652(bossChest, class_2246.field_10034.method_9564(), 3);
        class_2586 beBoss = world.method_8321(bossChest);
        if (beBoss instanceof class_2595) {
            class_2595 chest = (class_2595)beBoss;
            chest.method_54867(class_39.field_38438, random.method_43055());
        }
        for (int angle = 0; angle < 360; angle += 45) {
            double rad = Math.toRadians(angle);
            int sx = (int)Math.round(Math.cos(rad) * (double)(chamberRadius - 1));
            int sz = (int)Math.round(Math.sin(rad) * (double)(chamberRadius - 1));
            class_2338 col = center.method_10069(sx, 1, sz);
            world.method_8652(col, class_2246.field_10437.method_9564(), 3);
            world.method_8652(col.method_10086(3), class_2246.field_22110.method_9564(), 3);
        }
        class_2338 sp = center.method_10069(0, 2, 0);
        world.method_8652(sp, BlockType.PVP_SPAWNER_MAX.method_9564(), 3);
    }

    private static void buildGlassDome(class_5281 world, class_2338 origin, int floors, int floorHeight, int radius, class_5819 random) {
        int top = origin.method_10264() + floors * floorHeight + 3;
        for (int y = 0; y < 8; ++y) {
            for (int x = -radius; x <= radius; ++x) {
                block10: for (int z = -radius; z <= radius; ++z) {
                    double dist = Math.hypot(x, z);
                    if (!(dist < (double)radius - (double)y * 0.9)) continue;
                    class_2338 p = origin.method_10069(x, top + y, z);
                    if (y == 7 && dist < 2.0) {
                        world.method_8652(p, class_2246.field_10205.method_9564(), 3);
                        continue;
                    }
                    int pick = (Math.abs(x) + Math.abs(z) + y) % 7;
                    switch (pick) {
                        case 0: {
                            world.method_8652(p, class_2246.field_10272.method_9564(), 3);
                            continue block10;
                        }
                        case 1: {
                            world.method_8652(p, class_2246.field_10060.method_9564(), 3);
                            continue block10;
                        }
                        case 2: {
                            world.method_8652(p, class_2246.field_10357.method_9564(), 3);
                            continue block10;
                        }
                        case 3: {
                            world.method_8652(p, class_2246.field_10049.method_9564(), 3);
                            continue block10;
                        }
                        case 4: {
                            world.method_8652(p, class_2246.field_10399.method_9564(), 3);
                            continue block10;
                        }
                        case 5: {
                            world.method_8652(p, class_2246.field_10248.method_9564(), 3);
                            continue block10;
                        }
                        default: {
                            world.method_8652(p, class_2246.field_10087.method_9564(), 3);
                        }
                    }
                }
            }
        }
    }

    private static void buildEntranceBridge(class_5281 world, class_2338 origin, int radius, class_5819 random) {
        class_2338 doorBase = origin.method_10069(0, 0, -(radius + 2));
        world.method_8652(doorBase, class_2246.field_10149.method_9564(), 3);
        for (int i = 1; i <= 12; ++i) {
            class_2338 p = origin.method_10069(0, -1, -(radius + 2 + i));
            world.method_8652(p, class_2246.field_10056.method_9564(), 3);
            if (i % 3 == 0) {
                world.method_8652(p.method_10084(), class_2246.field_10336.method_9564(), 3);
            }
            if (!(random.method_43057() < 0.12f)) continue;
            world.method_8652(p.method_10086(2), class_2246.field_10597.method_9564(), 3);
        }
    }

    private static void addExteriorDecoration(class_5281 world, class_2338 origin, int radius, class_5819 random) {
        for (int x = -radius - 6; x <= radius + 6; x += 3) {
            for (int z = -radius - 6; z <= radius + 6; z += 3) {
                if (random.method_43057() < 0.08f) {
                    class_2338 p = origin.method_10069(x, 0, z);
                    world.method_8652(p.method_10084(), class_2246.field_10394.method_9564(), 3);
                }
                if (!(random.method_43057() < 0.04f)) continue;
                class_2338 v = origin.method_10069(x, 1, z);
                world.method_8652(v, class_2246.field_10597.method_9564(), 3);
            }
        }
        for (int i = -2; i <= 2; i += 2) {
            world.method_8652(origin.method_10069(radius + 1, 1, i), class_2246.field_16541.method_9564(), 3);
            world.method_8652(origin.method_10069(-(radius + 1), 1, i), class_2246.field_16541.method_9564(), 3);
        }
    }
}

