/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.helper;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import me.zcraft.tconfig.config.TritiumConfig;
import org.craftamethyst.tritium.TritiumCommon;
import org.craftamethyst.tritium.config.TritiumConfigBase;

public final class EntityTickHelper {
    private static final AtomicReference<Set<aev<?>>> WHITE_LIST = new AtomicReference(Collections.emptySet());
    private static final AtomicReference<Set<aev<?>>> BLACK_LIST = new AtomicReference(Collections.emptySet());
    private static final List<WildcardPattern> WHITE_PATTERNS = new ArrayList<WildcardPattern>();
    private static final List<WildcardPattern> BLACK_PATTERNS = new ArrayList<WildcardPattern>();
    private static final boolean ignoreDeadEntities = true;
    private static volatile boolean enabled = true;
    private static volatile int horizontalRange = 32;
    private static volatile int verticalRange = 16;

    public static boolean shouldSkipTick(aer entity) {
        if (!enabled) {
            return false;
        }
        if (!entity.aF()) {
            return false;
        }
        if (!entity.aF()) {
            return true;
        }
        aev type = entity.P();
        if (EntityTickHelper.matchesWildcard(type, BLACK_PATTERNS) || BLACK_LIST.get().contains(type)) {
            return true;
        }
        if (EntityTickHelper.matchesWildcard(type, WHITE_PATTERNS) || WHITE_LIST.get().contains(type)) {
            return false;
        }
        return !EntityTickHelper.isNearPlayer(entity);
    }

    private static void reloadConfig() {
        enabled = TritiumConfigBase.Entities.EntityOpt.optimizeEntities;
        horizontalRange = TritiumConfigBase.Entities.EntityOpt.horizontalRange;
        verticalRange = TritiumConfigBase.Entities.EntityOpt.verticalRange;
        List<String> whiteRaw = TritiumConfigBase.Entities.EntityOpt.entityWhitelist;
        HashSet whiteIds = Sets.newHashSet();
        WHITE_PATTERNS.clear();
        BLACK_PATTERNS.clear();
        for (String s : whiteRaw) {
            EntityTickHelper.parseEntry(s, whiteIds);
        }
        WHITE_LIST.set((Set<aev<?>>)ImmutableSet.copyOf((Collection)whiteIds));
    }

    private static void parseEntry(String raw, Set<aev<?>> idTarget) {
        if (raw.contains("*") || raw.contains("?")) {
            WHITE_PATTERNS.add(new WildcardPattern(raw));
        } else {
            try {
                pc key = new pc(raw);
                aev type = (aev)fc.r.a(key);
                if (type != null) {
                    idTarget.add(type);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static boolean matchesWildcard(aev<?> type, List<WildcardPattern> list) {
        pc id = fc.r.b(type);
        if (id == null) {
            return false;
        }
        String str = id.toString();
        for (WildcardPattern p : list) {
            if (!p.matches(str)) continue;
            return true;
        }
        return false;
    }

    private static boolean isNearPlayer(aer entity) {
        axy level = entity.m;
        if (!(level instanceof td)) {
            return true;
        }
        td sl = (td)level;
        el pos = entity.bH();
        int cx = pos.o() >> 4;
        int cz = pos.q() >> 4;
        int radius = (horizontalRange >> 4) + 1;
        cea box = new cea((double)(pos.o() - horizontalRange), (double)(pos.p() - verticalRange), (double)(pos.q() - horizontalRange), (double)(pos.o() + horizontalRange), (double)(pos.p() + verticalRange), (double)(pos.q() + horizontalRange));
        for (aog player : sl.j) {
            if (!player.aF()) continue;
            el ppos = player.bH();
            int pcx = ppos.o() >> 4;
            int pcz = ppos.q() >> 4;
            if (Math.abs(pcx - cx) > radius || Math.abs(pcz - cz) > radius || !player.bD().c(box)) continue;
            return true;
        }
        return false;
    }

    static {
        try {
            TritiumConfig config = TritiumConfig.getConfig("tritium");
            config.addReloadListener(EntityTickHelper::reloadConfig);
        }
        catch (Exception e) {
            TritiumCommon.LOG.error((Object)"Failed to register config reload listener", (Throwable)e);
        }
        EntityTickHelper.reloadConfig();
    }

    private static final class WildcardPattern {
        private final Pattern regex;

        WildcardPattern(String raw) {
            String s = raw.replace("?", ".{1}").replace("*", ".*");
            this.regex = Pattern.compile("^" + s + "$");
        }

        boolean matches(String str) {
            return this.regex.matcher(str).matches();
        }
    }
}

