/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.gpu;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.craftamethyst.tritium.TritiumCommon;
import org.craftamethyst.tritium.config.TritiumConfigBase;
import org.craftamethyst.tritium.gpu.FramebufferFixer;

public final class GpuPlus {
    private static final Queue<FramebufferFixer> FIXERS = new ConcurrentLinkedQueue<FramebufferFixer>();

    private GpuPlus() {
    }

    public static void enqueue(FramebufferFixer fixer) {
        if (fixer != null) {
            if (TritiumConfigBase.Rendering.GpuPlus.gpuPlus) {
                FIXERS.add(fixer);
            }
        }
    }

    public static void processQueue() {
        if (!TritiumConfigBase.Rendering.GpuPlus.gpuPlus) {
            return;
        }
        boolean destroyed = false;
        int counter = 0;
        while (!FIXERS.isEmpty() && counter++ < 20) {
            FramebufferFixer fixer = FIXERS.poll();
            if (fixer == null) continue;
            try {
                if (!destroyed) {
                    fixer.tritium$destroy();
                    destroyed = true;
                }
                fixer.tritium$release();
            }
            catch (Exception e) {
                TritiumCommon.LOG.error("[Tritium-GPU PLUS]Failed to process framebuffer cleanup for {}", (Object)fixer, (Object)e);
            }
        }
    }
}

