/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.mixin.cache;

import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import org.craftamethyst.tritium.config.TritiumConfigBase;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractFurnaceBlockEntity.class})
public abstract class AbstractFurnaceBlockEntityMixin {
    @Unique
    private static final int CACHE_INVALIDATION_TICKS = 200;
    @Unique
    private static final int DEFAULT_COOK_TIME = 200;
    @Unique
    private int tritium$cacheTicks = 0;
    @Unique
    @Nullable
    private AbstractCookingRecipe tritium$cachedRecipe;
    @Unique
    @Nullable
    private ItemStack tritium$cachedInput;
    @Unique
    private boolean tritium$cacheMissed = false;
    @Shadow
    @Final
    private RecipeManager.CachedCheck<Container, ? extends AbstractCookingRecipe> f_222691_;
    @Shadow
    protected NonNullList<ItemStack> f_58310_;

    @Shadow
    private static int m_222692_(Level level, AbstractFurnaceBlockEntity blockEntity) {
        throw new AssertionError();
    }

    @Unique
    private boolean tritium$isInputChanged(ItemStack currentInput) {
        if (this.tritium$cachedInput == null) {
            return !currentInput.m_41619_();
        }
        if (currentInput.m_41619_()) {
            return true;
        }
        return !ItemStack.m_41656_((ItemStack)this.tritium$cachedInput, (ItemStack)currentInput) || !ItemStack.m_150942_((ItemStack)this.tritium$cachedInput, (ItemStack)currentInput);
    }

    @Unique
    @Nullable
    private AbstractCookingRecipe tritium$getCachedRecipe(ItemStack currentInput) {
        ++this.tritium$cacheTicks;
        if (this.tritium$cacheTicks >= 200 || this.tritium$isInputChanged(currentInput)) {
            this.tritium$resetCache();
            return null;
        }
        return this.tritium$cacheMissed ? null : this.tritium$cachedRecipe;
    }

    @Unique
    private void tritium$updateCache(Level level, ItemStack input) {
        this.tritium$resetCache();
        if (input.m_41619_()) {
            return;
        }
        AbstractFurnaceBlockEntity self = (AbstractFurnaceBlockEntity)this;
        Optional recipe = this.f_222691_.m_213657_((Container)self, level);
        if (recipe.isPresent()) {
            this.tritium$cachedRecipe = (AbstractCookingRecipe)recipe.get();
            this.tritium$cachedInput = input.m_41777_();
            this.tritium$cacheMissed = false;
        } else {
            this.tritium$cacheMissed = true;
            this.tritium$cachedInput = input.m_41777_();
        }
        this.tritium$cacheTicks = 0;
    }

    @Unique
    private void tritium$resetCache() {
        this.tritium$cachedRecipe = null;
        this.tritium$cachedInput = null;
        this.tritium$cacheMissed = false;
        this.tritium$cacheTicks = 0;
    }

    @Unique
    private void tritium$validateAndUpdateCache(Level level, ItemStack currentInput) {
        if (level == null || currentInput.m_41619_()) {
            this.tritium$resetCache();
            return;
        }
        if (this.tritium$cachedRecipe == null && !this.tritium$cacheMissed) {
            this.tritium$updateCache(level, currentInput);
        }
    }

    @Redirect(method={"serverTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/AbstractFurnaceBlockEntity;getTotalCookTime(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/block/entity/AbstractFurnaceBlockEntity;)I"))
    private static int redirectGetTotalCookTime(Level level, AbstractFurnaceBlockEntity blockEntity) {
        if (!TritiumConfigBase.Performance.FastFurnace.fastFurnace) {
            return AbstractFurnaceBlockEntityMixin.m_222692_(level, blockEntity);
        }
        return ((AbstractFurnaceBlockEntityMixin)blockEntity).tritium$getCachedTotalCookTime(level);
    }

    @Unique
    private int tritium$getCachedTotalCookTime(Level level) {
        ItemStack currentInput;
        ItemStack itemStack = currentInput = this.f_58310_.isEmpty() ? ItemStack.f_41583_ : (ItemStack)this.f_58310_.get(0);
        if (currentInput.m_41619_()) {
            if (this.tritium$cachedInput != null || !this.tritium$cacheMissed) {
                this.tritium$resetCache();
            }
            return 200;
        }
        this.tritium$validateAndUpdateCache(level, currentInput);
        AbstractCookingRecipe recipe = this.tritium$getCachedRecipe(currentInput);
        if (recipe == null && !this.tritium$cacheMissed) {
            this.tritium$updateCache(level, currentInput);
            recipe = this.tritium$cachedRecipe;
        }
        return recipe != null ? recipe.m_43753_() : 200;
    }

    @Inject(method={"setItem"}, at={@At(value="HEAD")})
    private void onSetItem(int pIndex, ItemStack pStack, CallbackInfo ci) {
        if (!TritiumConfigBase.Performance.FastFurnace.fastFurnace) {
            return;
        }
        if (!(pIndex != 0 || this.tritium$cachedInput != null && ItemStack.m_150942_((ItemStack)this.tritium$cachedInput, (ItemStack)pStack))) {
            this.tritium$resetCache();
        }
    }
}

