/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.mixin.chunk;

import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.synth.SimplexNoise;
import org.craftamethyst.tritium.config.TritiumConfigBase;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(targets={"net.minecraft.world.level.levelgen.DensityFunctions$EndIslandDensityFunction"})
public class EndIslandDensityFunctionMixin {
    @Unique
    private static final int OPTIMIZED_RADIUS = 8;
    @Unique
    private static final long MAX_DISTANCE_SQ = 4096L;
    @Unique
    private static final float[] PRECOMPUTED_RARITY = new float[25];

    @Inject(method={"getHeightValue"}, at={@At(value="HEAD")}, cancellable=true)
    private static void optimizeGetHeightValue(SimplexNoise noise, int x, int z, CallbackInfoReturnable<Float> cir) {
        if (!TritiumConfigBase.Performance.EndIslandOptimization.enableEndIslandOptimization) {
            return;
        }
        int centerX = x / 2;
        int centerZ = z / 2;
        int offsetX = x % 2;
        int offsetZ = z % 2;
        int distanceSq = x * x + z * z;
        float distance = (float)Math.sqrt(distanceSq);
        float baseHeight = 100.0f - distance * 8.0f;
        baseHeight = Mth.m_14036_((float)baseHeight, (float)-100.0f, (float)80.0f);
        for (int dx = -8; dx <= 8; ++dx) {
            long worldX = centerX + dx;
            long worldXSq = worldX * worldX;
            for (int dz = -8; dz <= 8; ++dz) {
                float rarity;
                long worldZ = centerZ + dz;
                long chunkDistanceSq = worldXSq + worldZ * worldZ;
                if (chunkDistanceSq <= 4096L) continue;
                if (dx >= -2 && dx <= 2 && dz >= -2 && dz <= 2) {
                    int index = (dx + 2) * 5 + (dz + 2);
                    rarity = PRECOMPUTED_RARITY[index];
                } else {
                    rarity = (Math.abs((float)worldX) * 3439.0f + Math.abs((float)worldZ) * 147.0f) % 13.0f + 9.0f;
                }
                float localX = offsetX - dx * 2;
                float localZ = offsetZ - dz * 2;
                float localDistanceSq = localX * localX + localZ * localZ;
                float localDistance = (float)Math.sqrt(localDistanceSq);
                float islandHeight = 100.0f - localDistance * rarity;
                islandHeight = Mth.m_14036_((float)islandHeight, (float)-100.0f, (float)80.0f);
                baseHeight = Math.max(baseHeight, islandHeight);
            }
        }
        cir.setReturnValue((Object)Float.valueOf(baseHeight));
    }

    static {
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                int index = (i + 2) * 5 + (j + 2);
                EndIslandDensityFunctionMixin.PRECOMPUTED_RARITY[index] = ((float)Math.abs(i) * 3439.0f + (float)Math.abs(j) * 147.0f) % 13.0f + 9.0f;
            }
        }
    }
}

