/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.mixin.client.lang;

import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.LanguageManager;
import net.minecraft.server.packs.resources.ResourceManager;
import org.craftamethyst.tritium.TritiumCommon;
import org.craftamethyst.tritium.config.TritiumConfigBase;
import org.craftamethyst.tritium.util.LanguageLoadOptimizer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LanguageManager.class})
public abstract class LanguageManagerMixin {
    @Shadow
    private String f_118967_;
    @Unique
    private String tritium$previousLanguage;

    @Shadow
    protected abstract void m_6213_(ResourceManager var1);

    @Inject(method={"setSelected"}, at={@At(value="HEAD")})
    private void onSetLanguageHead(String languageCode, CallbackInfo ci) {
        if (!TritiumConfigBase.ClientOptimizations.FL.fastLanguageSwitch) {
            return;
        }
        this.tritium$previousLanguage = this.f_118967_;
        if (this.tritium$previousLanguage != null && !this.tritium$previousLanguage.equals(languageCode)) {
            LanguageLoadOptimizer.setLanguageChanging(true);
        }
    }

    @Inject(method={"setSelected"}, at={@At(value="TAIL")})
    private void onSetLanguageTail(String languageCode, CallbackInfo ci) {
        Minecraft minecraft;
        if (!TritiumConfigBase.ClientOptimizations.FL.fastLanguageSwitch) {
            return;
        }
        if (this.tritium$previousLanguage != null && !this.tritium$previousLanguage.equals(languageCode) && (minecraft = Minecraft.m_91087_()) != null && minecraft.m_91098_() != null) {
            try {
                this.m_6213_(minecraft.m_91098_());
            }
            catch (Exception e) {
                TritiumCommon.LOG.error("Failed to reload language resources", (Throwable)e);
                LanguageLoadOptimizer.reset();
            }
        }
    }
}

