/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.mixin.light;

import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.util.function.LongPredicate;
import net.minecraft.world.level.lighting.DynamicGraphMinFixedPoint;
import org.craftamethyst.tritium.config.TritiumConfigBase;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={DynamicGraphMinFixedPoint.class})
public abstract class DynamicGraphMinFixedPointMixin {
    @Mutable
    @Shadow
    @Final
    private Long2ByteMap f_75539_;

    @Shadow
    protected abstract void m_75600_(long var1);

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void init(int levelCount, int queueSize, int mapCapacity, CallbackInfo ci) {
        if (TritiumConfigBase.Performance.LightingOptimizations.enableLightingOptimizations && TritiumConfigBase.Performance.LightingOptimizations.optimizeDynamicGraph) {
            int capacity = 1 << 32 - Integer.numberOfLeadingZeros(mapCapacity - 1);
            Long2ByteOpenHashMap map = new Long2ByteOpenHashMap(capacity, 0.75f);
            map.defaultReturnValue((byte)-1);
            this.f_75539_ = map;
        }
    }

    @Inject(method={"removeIf"}, at={@At(value="HEAD")}, cancellable=true)
    private void removeIf(LongPredicate predicate, CallbackInfo ci) {
        if (TritiumConfigBase.Performance.LightingOptimizations.enableLightingOptimizations && TritiumConfigBase.Performance.LightingOptimizations.optimizeDynamicGraph) {
            ci.cancel();
            LongIterator it = this.f_75539_.keySet().iterator();
            while (it.hasNext()) {
                long pos = it.nextLong();
                if (!predicate.test(pos)) continue;
                this.m_75600_(pos);
            }
        }
    }
}

