/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.mixin.client.renderer.culling;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.craftamethyst.tritium.accessor.EntityRendererAccessor;
import org.craftamethyst.tritium.client.TritiumClient;
import org.craftamethyst.tritium.config.TritiumConfigBase;
import org.craftamethyst.tritium.cull.iface.EntityVisibility;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public class LevelRendererMixin {
    @Unique
    private final Minecraft tritium$mc = Minecraft.m_91087_();
    @Final
    @Shadow
    private EntityRenderDispatcher f_109463_;

    @Inject(method={"renderEntity"}, at={@At(value="TAIL")}, cancellable=true)
    private void tritium$skipCulledEntityButMaybeRenderNameTag(Entity entity, double cameraX, double cameraY, double cameraZ, float tickDelta, PoseStack matrices, MultiBufferSource consumers, CallbackInfo ci) {
        if (!TritiumConfigBase.Rendering.EntityCulling.enableCulling) {
            return;
        }
        TritiumClient client = TritiumClient.instance;
        if (client == null || !(entity instanceof EntityVisibility)) {
            return;
        }
        EntityVisibility cullable = (EntityVisibility)entity;
        if (cullable.tritium$isForcedVisible() || entity.f_19811_) {
            cullable.tritium$setOutOfCamera(false);
            return;
        }
        if (client.shouldSkipEntity(entity)) {
            if (!TritiumConfigBase.Rendering.EntityCulling.enableNameTagCulling && matrices != null && consumers != null && this.tritium$shouldRenderNameTag(entity)) {
                this.tritium$renderNameTag(entity, cameraX, cameraY, cameraZ, tickDelta, matrices, consumers);
            }
            ci.cancel();
            return;
        }
        cullable.tritium$setOutOfCamera(false);
    }

    @Unique
    private boolean tritium$shouldRenderNameTag(Entity entity) {
        EntityRendererAccessor accessor;
        EntityRenderer renderer = this.f_109463_.m_114382_(entity);
        return renderer instanceof EntityRendererAccessor && (accessor = (EntityRendererAccessor)renderer).tritium_shouldShowName(entity);
    }

    @Unique
    private void tritium$renderNameTag(Entity entity, double camX, double camY, double camZ, float tickDelta, PoseStack matrices, MultiBufferSource consumers) {
        EntityRenderer renderer = this.f_109463_.m_114382_(entity);
        if (!(renderer instanceof EntityRendererAccessor)) {
            return;
        }
        EntityRendererAccessor accessor = (EntityRendererAccessor)renderer;
        double x = Mth.m_14139_((double)tickDelta, (double)entity.f_19790_, (double)entity.m_20185_()) - camX;
        double y = Mth.m_14139_((double)tickDelta, (double)entity.f_19791_, (double)entity.m_20186_()) - camY;
        double z = Mth.m_14139_((double)tickDelta, (double)entity.f_19792_, (double)entity.m_20189_()) - camZ;
        Vec3 offset = renderer.m_7860_(entity, tickDelta);
        matrices.m_85836_();
        matrices.m_85837_(x + offset.f_82479_, y + offset.f_82480_, z + offset.f_82481_);
        accessor.tritium_renderNameTag(entity, entity.m_5446_(), matrices, consumers, this.f_109463_.m_114394_(entity, tickDelta));
        matrices.m_85849_();
    }
}

