/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.helper;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import me.zcraft.tconfig.config.TritiumConfig;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import org.craftamethyst.tritium.TritiumCommon;
import org.craftamethyst.tritium.config.TritiumConfigBase;

public final class EntityTickHelper {
    private static final AtomicReference<Set<EntityType<?>>> WHITE_LIST = new AtomicReference(Collections.emptySet());
    private static final AtomicReference<Set<EntityType<?>>> BLACK_LIST = new AtomicReference(Collections.emptySet());
    private static final List<WildcardPattern> WHITE_PATTERNS = new ArrayList<WildcardPattern>();
    private static final List<WildcardPattern> BLACK_PATTERNS = new ArrayList<WildcardPattern>();
    private static final boolean ignoreDeadEntities = true;
    private static volatile boolean enabled = true;
    private static volatile int horizontalRange = 32;
    private static volatile int verticalRange = 16;

    public static boolean shouldSkipTick(Entity entity) {
        if (!enabled) {
            return false;
        }
        if (!entity.func_70089_S()) {
            return false;
        }
        if (!entity.func_70089_S()) {
            return true;
        }
        EntityType type = entity.func_200600_R();
        if (EntityTickHelper.matchesWildcard(type, BLACK_PATTERNS) || BLACK_LIST.get().contains(type)) {
            return true;
        }
        if (EntityTickHelper.matchesWildcard(type, WHITE_PATTERNS) || WHITE_LIST.get().contains(type)) {
            return false;
        }
        return !EntityTickHelper.isNearPlayer(entity);
    }

    private static void reloadConfig() {
        enabled = TritiumConfigBase.Entities.EntityOpt.optimizeEntities;
        horizontalRange = TritiumConfigBase.Entities.EntityOpt.horizontalRange;
        verticalRange = TritiumConfigBase.Entities.EntityOpt.verticalRange;
        List<String> whiteRaw = TritiumConfigBase.Entities.EntityOpt.entityWhitelist;
        HashSet whiteIds = Sets.newHashSet();
        WHITE_PATTERNS.clear();
        BLACK_PATTERNS.clear();
        for (String s : whiteRaw) {
            EntityTickHelper.parseEntry(s, whiteIds);
        }
        WHITE_LIST.set((Set<EntityType<?>>)ImmutableSet.copyOf((Collection)whiteIds));
    }

    private static void parseEntry(String raw, Set<EntityType<?>> idTarget) {
        if (raw.contains("*") || raw.contains("?")) {
            WHITE_PATTERNS.add(new WildcardPattern(raw));
        } else {
            try {
                ResourceLocation key = new ResourceLocation(raw);
                EntityType type = (EntityType)IRegistry.field_212629_r.func_82594_a(key);
                if (type != null) {
                    idTarget.add(type);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static boolean matchesWildcard(EntityType<?> type, List<WildcardPattern> list) {
        ResourceLocation id = IRegistry.field_212629_r.func_177774_c(type);
        if (id == null) {
            return false;
        }
        String str = id.toString();
        for (WildcardPattern p : list) {
            if (!p.matches(str)) continue;
            return true;
        }
        return false;
    }

    private static boolean isNearPlayer(Entity entity) {
        World level = entity.field_70170_p;
        if (!(level instanceof WorldServer)) {
            return true;
        }
        WorldServer sl = (WorldServer)level;
        BlockPos pos = entity.func_180425_c();
        int cx = pos.func_177958_n() >> 4;
        int cz = pos.func_177952_p() >> 4;
        int radius = (horizontalRange >> 4) + 1;
        AxisAlignedBB box = new AxisAlignedBB((double)(pos.func_177958_n() - horizontalRange), (double)(pos.func_177956_o() - verticalRange), (double)(pos.func_177952_p() - horizontalRange), (double)(pos.func_177958_n() + horizontalRange), (double)(pos.func_177956_o() + verticalRange), (double)(pos.func_177952_p() + horizontalRange));
        for (EntityPlayer player : sl.field_73010_i) {
            if (!player.func_70089_S()) continue;
            BlockPos ppos = player.func_180425_c();
            int pcx = ppos.func_177958_n() >> 4;
            int pcz = ppos.func_177952_p() >> 4;
            if (Math.abs(pcx - cx) > radius || Math.abs(pcz - cz) > radius || !player.func_174813_aQ().func_72326_a(box)) continue;
            return true;
        }
        return false;
    }

    static {
        try {
            TritiumConfig config = TritiumConfig.getConfig("tritium");
            config.addReloadListener(EntityTickHelper::reloadConfig);
        }
        catch (Exception e) {
            TritiumCommon.LOG.error((Object)"Failed to register config reload listener", (Throwable)e);
        }
        EntityTickHelper.reloadConfig();
    }

    private static final class WildcardPattern {
        private final Pattern regex;

        WildcardPattern(String raw) {
            String s = raw.replace("?", ".{1}").replace("*", ".*");
            this.regex = Pattern.compile("^" + s + "$");
        }

        boolean matches(String str) {
            return this.regex.matcher(str).matches();
        }
    }
}

