/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.mixin.cache;

import java.util.Optional;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1863;
import net.minecraft.class_1874;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2609;
import org.craftamethyst.tritium.config.TritiumConfigBase;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_2609.class})
public abstract class AbstractFurnaceBlockEntityMixin {
    @Unique
    private static final int CACHE_INVALIDATION_TICKS = 200;
    @Unique
    private static final int DEFAULT_COOK_TIME = 200;
    @Unique
    private int tritium$cacheTicks = 0;
    @Unique
    @Nullable
    private class_1874 tritium$cachedRecipe;
    @Unique
    @Nullable
    private class_1799 tritium$cachedInput;
    @Unique
    private boolean tritium$cacheMissed = false;
    @Shadow
    @Final
    private class_1863.class_7266<class_1263, ? extends class_1874> field_38234;
    @Shadow
    protected class_2371<class_1799> field_11984;

    @Shadow
    private static int method_17029(class_1937 level, class_2609 blockEntity) {
        throw new AssertionError();
    }

    @Unique
    private boolean tritium$isInputChanged(class_1799 currentInput) {
        if (this.tritium$cachedInput == null) {
            return !currentInput.method_7960();
        }
        if (currentInput.method_7960()) {
            return true;
        }
        return !class_1799.method_7984((class_1799)this.tritium$cachedInput, (class_1799)currentInput) || !class_1799.method_31577((class_1799)this.tritium$cachedInput, (class_1799)currentInput);
    }

    @Unique
    @Nullable
    private class_1874 tritium$getCachedRecipe(class_1799 currentInput) {
        ++this.tritium$cacheTicks;
        if (this.tritium$cacheTicks >= 200 || this.tritium$isInputChanged(currentInput)) {
            this.tritium$resetCache();
            return null;
        }
        return this.tritium$cacheMissed ? null : this.tritium$cachedRecipe;
    }

    @Unique
    private void tritium$updateCache(class_1937 level, class_1799 input) {
        this.tritium$resetCache();
        if (input.method_7960()) {
            return;
        }
        class_2609 self = (class_2609)this;
        Optional recipe = this.field_38234.method_42303((class_1263)self, level);
        if (recipe.isPresent()) {
            this.tritium$cachedRecipe = (class_1874)recipe.get();
            this.tritium$cachedInput = input.method_7972();
            this.tritium$cacheMissed = false;
        } else {
            this.tritium$cacheMissed = true;
            this.tritium$cachedInput = input.method_7972();
        }
        this.tritium$cacheTicks = 0;
    }

    @Unique
    private void tritium$resetCache() {
        this.tritium$cachedRecipe = null;
        this.tritium$cachedInput = null;
        this.tritium$cacheMissed = false;
        this.tritium$cacheTicks = 0;
    }

    @Unique
    private void tritium$validateAndUpdateCache(class_1937 level, class_1799 currentInput) {
        if (level == null || currentInput.method_7960()) {
            this.tritium$resetCache();
            return;
        }
        if (this.tritium$cachedRecipe == null && !this.tritium$cacheMissed) {
            this.tritium$updateCache(level, currentInput);
        }
    }

    @Redirect(method={"serverTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/AbstractFurnaceBlockEntity;getTotalCookTime(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/block/entity/AbstractFurnaceBlockEntity;)I"))
    private static int redirectGetTotalCookTime(class_1937 level, class_2609 blockEntity) {
        if (!TritiumConfigBase.Performance.FastFurnace.fastFurnace) {
            return AbstractFurnaceBlockEntityMixin.method_17029(level, blockEntity);
        }
        return ((AbstractFurnaceBlockEntityMixin)blockEntity).tritium$getCachedTotalCookTime(level);
    }

    @Unique
    private int tritium$getCachedTotalCookTime(class_1937 level) {
        class_1799 currentInput;
        class_1799 class_17992 = currentInput = this.field_11984.isEmpty() ? class_1799.field_8037 : (class_1799)this.field_11984.get(0);
        if (currentInput.method_7960()) {
            if (this.tritium$cachedInput != null || !this.tritium$cacheMissed) {
                this.tritium$resetCache();
            }
            return 200;
        }
        this.tritium$validateAndUpdateCache(level, currentInput);
        class_1874 recipe = this.tritium$getCachedRecipe(currentInput);
        if (recipe == null && !this.tritium$cacheMissed) {
            this.tritium$updateCache(level, currentInput);
            recipe = this.tritium$cachedRecipe;
        }
        return recipe != null ? recipe.method_8167() : 200;
    }

    @Inject(method={"setItem"}, at={@At(value="HEAD")})
    private void onSetItem(int pIndex, class_1799 pStack, CallbackInfo ci) {
        if (!TritiumConfigBase.Performance.FastFurnace.fastFurnace) {
            return;
        }
        if (!(pIndex != 0 || this.tritium$cachedInput != null && class_1799.method_31577((class_1799)this.tritium$cachedInput, (class_1799)pStack))) {
            this.tritium$resetCache();
        }
    }
}

