/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.mixin.jigsaw;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.IntArrays;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_5819;
import org.craftamethyst.tritium.config.TritiumConfigBase;
import org.craftamethyst.tritium.platform.Services;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3785.class})
public class StructureTemplatePoolMixin {
    @Shadow
    @Final
    private List<Pair<class_3784, Integer>> field_16864;
    @Unique
    private final Object tritium$lock = new Object();
    @Unique
    private volatile boolean tritium$initialized = false;
    @Unique
    private class_3784[] tritium$elements;
    @Unique
    private int[] tritium$prefix;
    @Unique
    private int tritium$total;
    @Unique
    private static final boolean SPA_LOADED = Services.PLATFORM.isModLoaded("structure_pool_api");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Inject(method={"getShuffledTemplates"}, at={@At(value="HEAD")}, cancellable=true, require=1)
    private void tritium$fastWeightedSample(class_5819 random, CallbackInfoReturnable<List<class_3784>> cir) {
        if (!SPA_LOADED) {
            return;
        }
        if (!TritiumConfigBase.ServerPerformance.JigsawOptimizations.enableJigsawOptimizations || !TritiumConfigBase.ServerPerformance.JigsawOptimizations.enableFastWeightedSampling) {
            return;
        }
        try {
            if (!this.tritium$initialized) {
                Object object = this.tritium$lock;
                synchronized (object) {
                    if (!this.tritium$initialized) {
                        this.tritium$init();
                        this.tritium$initialized = true;
                    }
                }
            }
            if (this.tritium$elements == null || this.tritium$elements.length == 0 || this.tritium$total <= 0) {
                return;
            }
            int point = random.method_43048(this.tritium$total);
            int idx = IntArrays.binarySearch((int[])this.tritium$prefix, (int)point);
            if (idx < 0) {
                idx = -idx - 1;
            }
            if (idx < this.tritium$elements.length && this.tritium$elements[idx] != null) {
                cir.setReturnValue(Collections.singletonList(this.tritium$elements[idx]));
            }
        }
        catch (Exception e) {
            System.err.println("Tritium StructureTemplatePool failed, falling back to vanilla: " + e.getMessage());
        }
    }

    @Unique
    private void tritium$init() {
        try {
            int n = this.field_16864.size();
            this.tritium$elements = new class_3784[n];
            this.tritium$prefix = new int[n];
            int cursor = 0;
            int i = 0;
            for (Pair<class_3784, Integer> pair : this.field_16864) {
                class_3784 ele = (class_3784)pair.getFirst();
                int w = (Integer)pair.getSecond();
                if (w <= 0 || ele == null) continue;
                this.tritium$elements[i] = ele;
                this.tritium$prefix[i] = cursor += w;
                ++i;
            }
            if (i == 0) {
                this.tritium$elements = null;
                this.tritium$prefix = null;
                this.tritium$total = 0;
                return;
            }
            if (i < n) {
                this.tritium$elements = Arrays.copyOf(this.tritium$elements, i);
                this.tritium$prefix = Arrays.copyOf(this.tritium$prefix, i);
            }
            this.tritium$total = cursor;
        }
        catch (Exception e) {
            this.tritium$elements = null;
            this.tritium$prefix = null;
            this.tritium$total = 0;
            System.err.println("Tritium StructureTemplatePoolMixin init failed: " + e.getMessage());
        }
    }
}

