/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.client;

import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.craftamethyst.tritium.config.TritiumConfigBase;
import org.craftamethyst.tritium.cull.AABBCullingManager;
import org.craftamethyst.tritium.cull.CullCache;

public class TritiumClient {
    public static TritiumClient instance;
    private final CullCache cache = new CullCache();
    private final AABBCullingManager aabbCulling = new AABBCullingManager();
    private class_243 lastCameraPos = class_243.field_1353;
    private int framesSinceLastUpdate = 0;

    public TritiumClient() {
        instance = this;
    }

    public static void shutdown() {
        if (instance != null) {
            TritiumClient.instance.aabbCulling.dispose();
            TritiumClient.instance.cache.clear();
        }
    }

    public boolean shouldSkipEntity(class_1297 e) {
        if (e == null) {
            return false;
        }
        if (!TritiumConfigBase.Rendering.EntityCulling.enableCulling) {
            return false;
        }
        if (this.isEntityBlacklisted(e)) {
            return false;
        }
        this.updateCameraPosition();
        return this.aabbCulling.shouldCullEntity(e);
    }

    public boolean shouldSkipBlockEntity(class_2586 be) {
        if (be == null) {
            return false;
        }
        if (!TritiumConfigBase.Rendering.EntityCulling.enableBlockEntityCulling) {
            return false;
        }
        this.updateCameraPosition();
        return this.aabbCulling.shouldCullBlockEntity(be);
    }

    public CullCache getCullCache() {
        return this.cache;
    }

    public AABBCullingManager getAABBCullingManager() {
        return this.aabbCulling;
    }

    private boolean isEntityBlacklisted(class_1297 entity) {
        class_2960 entityId = class_1299.method_5890((class_1299)entity.method_5864());
        String entityName = entityId.toString();
        List<String> blacklist = TritiumConfigBase.Rendering.EntityCulling.entityBlacklist;
        for (String pattern : blacklist) {
            if (!this.matchesPattern(entityName, pattern)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesPattern(String entityName, String pattern) {
        if (pattern.equals("*")) {
            return true;
        }
        if (pattern.endsWith(":*")) {
            String namespace = pattern.substring(0, pattern.length() - 2);
            return entityName.startsWith(namespace + ":");
        }
        return entityName.equals(pattern);
    }

    private void updateCameraPosition() {
        class_310 mc = class_310.method_1551();
        class_243 currentCameraPos = mc.field_1773.method_19418().method_19326();
        ++this.framesSinceLastUpdate;
        if (this.framesSinceLastUpdate >= 5 || currentCameraPos.method_1025(this.lastCameraPos) > 4.0) {
            this.lastCameraPos = currentCameraPos;
            this.aabbCulling.updateCameraPosition();
            this.framesSinceLastUpdate = 0;
        }
    }
}

