/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.helper;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import me.zcraft.tconfig.config.TritiumConfig;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3763;
import net.minecraft.class_7923;
import org.craftamethyst.tritium.TritiumCommon;
import org.craftamethyst.tritium.config.TritiumConfigBase;

public final class EntityTickHelper {
    private static final AtomicReference<Set<class_1299<?>>> WHITE_LIST = new AtomicReference(Collections.emptySet());
    private static final AtomicReference<Set<class_1299<?>>> BLACK_LIST = new AtomicReference(Collections.emptySet());
    private static final List<WildcardPattern> WHITE_PATTERNS = new ArrayList<WildcardPattern>();
    private static final List<WildcardPattern> BLACK_PATTERNS = new ArrayList<WildcardPattern>();
    private static final boolean ignoreDeadEntities = true;
    private static volatile boolean enabled = true;
    private static volatile boolean tickRaidersInRaid = true;
    private static volatile int horizontalRange = 32;
    private static volatile int verticalRange = 16;

    public static boolean shouldSkipTick(class_1297 entity) {
        if (!enabled) {
            return false;
        }
        if (!(entity instanceof class_1309)) {
            return false;
        }
        class_1309 living = (class_1309)entity;
        if (!living.method_5805()) {
            return false;
        }
        if (!living.method_5805()) {
            return true;
        }
        class_1299 type = entity.method_5864();
        if (EntityTickHelper.matchesWildcard(type, BLACK_PATTERNS) || BLACK_LIST.get().contains(type)) {
            return true;
        }
        if (EntityTickHelper.matchesWildcard(type, WHITE_PATTERNS) || WHITE_LIST.get().contains(type)) {
            return false;
        }
        if (tickRaidersInRaid && EntityTickHelper.isRaiderInRaid(living)) {
            return false;
        }
        return !EntityTickHelper.isNearPlayer(living);
    }

    private static void reloadConfig() {
        enabled = TritiumConfigBase.Entities.EntityOpt.optimizeEntities;
        tickRaidersInRaid = TritiumConfigBase.Entities.EntityOpt.tickRaidersInRaid;
        horizontalRange = TritiumConfigBase.Entities.EntityOpt.horizontalRange;
        verticalRange = TritiumConfigBase.Entities.EntityOpt.verticalRange;
        List<String> whiteRaw = TritiumConfigBase.Entities.EntityOpt.entityWhitelist;
        HashSet whiteIds = Sets.newHashSet();
        WHITE_PATTERNS.clear();
        BLACK_PATTERNS.clear();
        whiteRaw.forEach(s -> EntityTickHelper.parseEntry(s, whiteIds));
        WHITE_LIST.set((Set<class_1299<?>>)ImmutableSet.copyOf((Collection)whiteIds));
    }

    private static void parseEntry(String raw, Set<class_1299<?>> idTarget) {
        if (raw.contains("*") || raw.contains("?")) {
            WHITE_PATTERNS.add(new WildcardPattern(raw));
        } else {
            class_2960 key = class_2960.method_12829((String)raw);
            if (key != null) {
                class_1299 type = (class_1299)class_7923.field_41177.method_10223(key);
                idTarget.add(type);
            }
        }
    }

    private static boolean matchesWildcard(class_1299<?> type, List<WildcardPattern> list) {
        class_2960 id = class_7923.field_41177.method_10221(type);
        String str = id.toString();
        for (WildcardPattern p : list) {
            if (!p.matches(str)) continue;
            return true;
        }
        return false;
    }

    private static boolean isRaiderInRaid(class_1309 e) {
        class_3763 raider;
        return e instanceof class_3763 && (raider = (class_3763)e).method_5805() && raider.method_16482();
    }

    private static boolean isNearPlayer(class_1309 entity) {
        class_1937 level = entity.method_37908();
        if (!(level instanceof class_3218)) {
            return true;
        }
        class_3218 sl = (class_3218)level;
        class_2338 pos = entity.method_24515();
        int cx = pos.method_10263() >> 4;
        int cz = pos.method_10260() >> 4;
        int radius = (horizontalRange >> 4) + 1;
        class_238 box = new class_238((double)(pos.method_10263() - horizontalRange), (double)(pos.method_10264() - verticalRange), (double)(pos.method_10260() - horizontalRange), (double)(pos.method_10263() + horizontalRange), (double)(pos.method_10264() + verticalRange), (double)(pos.method_10260() + horizontalRange));
        for (class_1657 player : sl.method_18456()) {
            if (!player.method_5805()) continue;
            class_2338 ppos = player.method_24515();
            int pcx = ppos.method_10263() >> 4;
            int pcz = ppos.method_10260() >> 4;
            if (Math.abs(pcx - cx) > radius || Math.abs(pcz - cz) > radius || !player.method_5829().method_994(box)) continue;
            return true;
        }
        return false;
    }

    static {
        try {
            TritiumConfig config = TritiumConfig.getConfig("tritium");
            config.addReloadListener(EntityTickHelper::reloadConfig);
        }
        catch (Exception e) {
            TritiumCommon.LOG.error("Failed to register config reload listener", (Throwable)e);
        }
        EntityTickHelper.reloadConfig();
    }

    private static final class WildcardPattern {
        private final Pattern regex;

        WildcardPattern(String raw) {
            String s = raw.replace("?", ".{1}").replace("*", ".*");
            this.regex = Pattern.compile("^" + s + "$");
        }

        boolean matches(String str) {
            return this.regex.matcher(str).matches();
        }
    }
}

