/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.mixin.math;

import net.minecraft.class_3532;
import net.minecraft.class_5819;
import org.craftamethyst.tritium.config.TritiumConfigBase;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3532.class})
public class MthMixin {
    @Inject(method={"lerp(FFF)F"}, at={@At(value="HEAD")}, cancellable=true)
    private static void optimizeLerpFloat(float pDelta, float pStart, float pEnd, CallbackInfoReturnable<Float> cir) {
        if (TritiumConfigBase.Performance.MathOptimizations.enableMathOptimizations && TritiumConfigBase.Performance.MathOptimizations.optimizeLerpFunctions) {
            cir.setReturnValue((Object)Float.valueOf(Math.fma(pDelta, pEnd - pStart, pStart)));
        }
    }

    @Inject(method={"lengthSquared(DD)D"}, at={@At(value="HEAD")}, cancellable=true)
    private static void optimizeLengthSquared2D(double pXDistance, double pYDistance, CallbackInfoReturnable<Double> cir) {
        if (TritiumConfigBase.Performance.MathOptimizations.enableMathOptimizations && TritiumConfigBase.Performance.MathOptimizations.optimizeLengthSquared) {
            cir.setReturnValue((Object)Math.fma(pXDistance, pXDistance, pYDistance * pYDistance));
        }
    }

    @Inject(method={"lengthSquared(DDD)D"}, at={@At(value="HEAD")}, cancellable=true)
    private static void optimizeLengthSquared3D(double pXDistance, double pYDistance, double pZDistance, CallbackInfoReturnable<Double> cir) {
        if (TritiumConfigBase.Performance.MathOptimizations.enableMathOptimizations && TritiumConfigBase.Performance.MathOptimizations.optimizeLengthSquared) {
            cir.setReturnValue((Object)Math.fma(pXDistance, pXDistance, Math.fma(pYDistance, pYDistance, pZDistance * pZDistance)));
        }
    }

    @Inject(method={"nextFloat(Lnet/minecraft/util/RandomSource;FF)F"}, at={@At(value="HEAD")}, cancellable=true)
    private static void optimizeNextFloat(class_5819 pRandom, float pMinimum, float pMaximum, CallbackInfoReturnable<Float> cir) {
        if (TritiumConfigBase.Performance.MathOptimizations.enableMathOptimizations && TritiumConfigBase.Performance.MathOptimizations.optimizeRandomFunctions) {
            if (pMinimum >= pMaximum) {
                cir.setReturnValue((Object)Float.valueOf(pMinimum));
            } else {
                cir.setReturnValue((Object)Float.valueOf(Math.fma(pRandom.method_43057(), pMaximum - pMinimum, pMinimum)));
            }
        }
    }

    @Inject(method={"nextDouble(Lnet/minecraft/util/RandomSource;DD)D"}, at={@At(value="HEAD")}, cancellable=true)
    private static void optimizeNextDouble(class_5819 pRandom, double pMinimum, double pMaximum, CallbackInfoReturnable<Double> cir) {
        if (TritiumConfigBase.Performance.MathOptimizations.enableMathOptimizations && TritiumConfigBase.Performance.MathOptimizations.optimizeRandomFunctions) {
            if (pMinimum >= pMaximum) {
                cir.setReturnValue((Object)pMinimum);
            } else {
                cir.setReturnValue((Object)Math.fma(pRandom.method_43058(), pMaximum - pMinimum, pMinimum));
            }
        }
    }

    @Inject(method={"normal(Lnet/minecraft/util/RandomSource;FF)F"}, at={@At(value="HEAD")}, cancellable=true)
    private static void optimizeNormal(class_5819 pRandom, float pMean, float pDeviation, CallbackInfoReturnable<Float> cir) {
        if (TritiumConfigBase.Performance.MathOptimizations.enableMathOptimizations && TritiumConfigBase.Performance.MathOptimizations.optimizeRandomFunctions) {
            cir.setReturnValue((Object)Float.valueOf(Math.fma((float)pRandom.method_43059(), pDeviation, pMean)));
        }
    }
}

