/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.cull;

import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.craftamethyst.tritium.cull.CullCache;
import org.craftamethyst.tritium.cull.OcclusionProvider;
import org.craftamethyst.tritium.cull.iface.BlockEntityVisibility;
import org.craftamethyst.tritium.cull.iface.EntityVisibility;
import org.craftamethyst.tritium.libs.com.logisticscraft.occlusionculling.OcclusionCullingInstance;
import org.craftamethyst.tritium.libs.com.logisticscraft.occlusionculling.util.Vec3d;

public class AABBCullingManager {
    private static final double HITBOX_LIMIT = 10.0;
    private static final double MANHATTAN_THRESHOLD = 1.732;
    private static final long CAMERA_UPDATE_INTERVAL = 50L;
    private static final long DISTANCE_UPDATE_INTERVAL = 1000L;
    private static final double RESET_DISTANCE_THRESHOLD = 2.0;
    private static final long MIN_RESET_INTERVAL = 1000L;
    private final OcclusionCullingInstance occlusionCulling;
    private final CullCache cullCache = new CullCache();
    private final Minecraft mc;
    private final AABBOBJ reusableAABB = new AABBOBJ(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private final Vec3d reusableAabbMin = new Vec3d(0.0, 0.0, 0.0);
    private final Vec3d reusableAabbMax = new Vec3d(0.0, 0.0, 0.0);
    private final Vec3d reusableCamera = new Vec3d(0.0, 0.0, 0.0);
    private Vec3 cachedCameraPos = Vec3.f_82478_;
    private double cachedCullingDistance = 128.0;
    private long lastCameraUpdate = 0L;
    private long lastDistanceUpdate = 0L;
    private Vec3 lastResetCameraPos = Vec3.f_82478_;
    private long lastResetTime = 0L;

    public AABBCullingManager() {
        this.mc = Minecraft.m_91087_();
        this.occlusionCulling = new OcclusionCullingInstance(64, new OcclusionProvider());
    }

    public boolean shouldCullEntity(Entity entity) {
        EntityVisibility cullable;
        if (this.isPlayerSprinting()) {
            return false;
        }
        if (entity == null) {
            return false;
        }
        if (this.mc.f_91073_ == null) {
            return false;
        }
        CullCache.CullResult cached = this.cullCache.checkEntity(entity);
        if (cached.isCached()) {
            return cached.isCulled();
        }
        if (entity instanceof EntityVisibility && (cullable = (EntityVisibility)entity).tritium$isForcedVisible()) {
            this.cullCache.cacheEntity(entity, false);
            return false;
        }
        if (!this.needsDetailedEntityCheck(entity)) {
            this.cullCache.cacheEntity(entity, false);
            return false;
        }
        Vec3 cameraPos = this.getCachedCameraPos();
        double cullingDistance = this.getCachedCullingDistance();
        if (this.isWithinDistanceOptimized(entity.m_146892_(), cameraPos, cullingDistance)) {
            this.cullCache.cacheEntity(entity, true);
            return true;
        }
        AABB boundingBox = entity.m_20191_();
        if (this.isLargeEntity(boundingBox)) {
            this.cullCache.cacheEntity(entity, false);
            return false;
        }
        boolean visible = this.performOcclusionCheck(boundingBox, cameraPos);
        boolean shouldCull = !visible;
        this.cullCache.cacheEntity(entity, shouldCull);
        return shouldCull;
    }

    public boolean shouldCullBlockEntity(BlockEntity blockEntity) {
        BlockEntityVisibility cullable;
        if (this.isPlayerSprinting()) {
            return false;
        }
        if (blockEntity == null) {
            return false;
        }
        if (this.mc.f_91073_ == null) {
            return false;
        }
        CullCache.CullResult cached = this.cullCache.checkBlockEntity(blockEntity);
        if (cached.isCached()) {
            return cached.isCulled();
        }
        if (blockEntity instanceof BlockEntityVisibility && (cullable = (BlockEntityVisibility)blockEntity).tritium$isForcedVisible()) {
            this.cullCache.cacheBlockEntity(blockEntity, false);
            return false;
        }
        Vec3 cameraPos = this.getCachedCameraPos();
        double cullingDistance = this.getCachedCullingDistance();
        if (this.isWithinDistanceOptimized(blockEntity.m_58899_().m_252807_(), cameraPos, cullingDistance)) {
            this.cullCache.cacheBlockEntity(blockEntity, true);
            return true;
        }
        BlockPos pos = blockEntity.m_58899_();
        this.reusableAABB.set(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), pos.m_123341_() + 1, pos.m_123342_() + 1, pos.m_123343_() + 1);
        boolean visible = this.performOcclusionCheck(this.reusableAABB, cameraPos);
        boolean shouldCull = !visible;
        this.cullCache.cacheBlockEntity(blockEntity, shouldCull);
        return shouldCull;
    }

    private boolean needsDetailedEntityCheck(Entity entity) {
        ArmorStand armorStand;
        if (entity.m_20145_()) {
            return false;
        }
        if (entity == this.mc.m_91288_()) {
            return false;
        }
        if (entity == this.mc.f_91074_) {
            return false;
        }
        if (entity.m_5833_()) {
            return false;
        }
        if (entity.m_20160_()) {
            return false;
        }
        if (entity.m_20159_()) {
            return false;
        }
        return !(entity instanceof ArmorStand) || !(armorStand = (ArmorStand)entity).m_31677_();
    }

    private boolean isWithinDistanceOptimized(Vec3 entityPos, Vec3 cameraPos, double distance) {
        double manhattan = Math.abs(entityPos.f_82479_ - cameraPos.f_82479_) + Math.abs(entityPos.f_82480_ - cameraPos.f_82480_) + Math.abs(entityPos.f_82481_ - cameraPos.f_82481_);
        if (manhattan > distance * 1.732) {
            return true;
        }
        double dx = entityPos.f_82479_ - cameraPos.f_82479_;
        double dy = entityPos.f_82480_ - cameraPos.f_82480_;
        double dz = entityPos.f_82481_ - cameraPos.f_82481_;
        double distanceSq = dx * dx + dy * dy + dz * dz;
        return !(distanceSq <= distance * distance);
    }

    private boolean performOcclusionCheck(AABB boundingBox, Vec3 cameraPos) {
        this.reusableAabbMin.set(boundingBox.f_82288_, boundingBox.f_82289_, boundingBox.f_82290_);
        this.reusableAabbMax.set(boundingBox.f_82291_, boundingBox.f_82292_, boundingBox.f_82293_);
        this.reusableCamera.set(cameraPos.f_82479_, cameraPos.f_82480_, cameraPos.f_82481_);
        return this.occlusionCulling.isAABBVisible(this.reusableAabbMin, this.reusableAabbMax, this.reusableCamera);
    }

    private boolean performOcclusionCheck(AABBOBJ boundingBox, Vec3 cameraPos) {
        this.reusableAabbMin.set(boundingBox.minX, boundingBox.minY, boundingBox.minZ);
        this.reusableAabbMax.set(boundingBox.maxX, boundingBox.maxY, boundingBox.maxZ);
        this.reusableCamera.set(cameraPos.f_82479_, cameraPos.f_82480_, cameraPos.f_82481_);
        return this.occlusionCulling.isAABBVisible(this.reusableAabbMin, this.reusableAabbMax, this.reusableCamera);
    }

    private boolean isLargeEntity(AABB boundingBox) {
        return boundingBox.m_82362_() > 10.0 || boundingBox.m_82376_() > 10.0 || boundingBox.m_82385_() > 10.0;
    }

    private Vec3 getCachedCameraPos() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastCameraUpdate > 50L) {
            Camera mainCamera = this.mc.f_91063_.m_109153_();
            this.cachedCameraPos = mainCamera.m_90583_();
            this.lastCameraUpdate = currentTime;
        }
        return this.cachedCameraPos;
    }

    private double getCachedCullingDistance() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastDistanceUpdate > 1000L) {
            this.cachedCullingDistance = this.mc.f_91073_ == null ? 128.0 : (double)(this.mc.f_91073_.m_194186_() * 16) * 1.1;
            this.lastDistanceUpdate = currentTime;
        }
        return this.cachedCullingDistance;
    }

    public void updateCameraPosition() {
        Vec3 currentCameraPos = this.getCachedCameraPos();
        long currentTime = System.currentTimeMillis();
        boolean shouldReset = false;
        if (this.lastResetCameraPos == Vec3.f_82478_) {
            shouldReset = true;
        } else {
            double distanceMoved = currentCameraPos.m_82554_(this.lastResetCameraPos);
            if (distanceMoved > 2.0) {
                shouldReset = true;
            }
        }
        if (currentTime - this.lastResetTime > 1000L) {
            shouldReset = true;
        }
        if (shouldReset) {
            this.occlusionCulling.resetCache();
            this.lastResetCameraPos = currentCameraPos;
            this.lastResetTime = currentTime;
        }
        this.lastCameraUpdate = 0L;
    }

    public void dispose() {
        this.cullCache.clear();
        this.lastResetCameraPos = Vec3.f_82478_;
        this.lastResetTime = 0L;
    }

    private boolean isPlayerSprinting() {
        return this.mc.f_91074_ != null && this.mc.f_91074_.m_20142_();
    }

    public double getCurrentCullingDistance() {
        return this.cachedCullingDistance;
    }

    public OcclusionCullingInstance getOcclusionCulling() {
        return this.occlusionCulling;
    }

    public void forceResetCache() {
        this.occlusionCulling.resetCache();
        this.lastResetCameraPos = this.getCachedCameraPos();
        this.lastResetTime = System.currentTimeMillis();
    }

    public static class AABBOBJ {
        public double minX;
        public double minY;
        public double minZ;
        public double maxX;
        public double maxY;
        public double maxZ;

        public AABBOBJ(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
            this.set(minX, minY, minZ, maxX, maxY, maxZ);
        }

        public void set(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
            this.minX = minX;
            this.minY = minY;
            this.minZ = minZ;
            this.maxX = maxX;
            this.maxY = maxY;
            this.maxZ = maxZ;
        }

        public double getXsize() {
            return this.maxX - this.minX;
        }

        public double getYsize() {
            return this.maxY - this.minY;
        }

        public double getZsize() {
            return this.maxZ - this.minZ;
        }
    }
}

