/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.cull;

import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.craftamethyst.tritium.cull.LeafCulling;

public final class BlockFaceOcclusionCuller {
    private static final AtomicBoolean FALLBACK_MODE = new AtomicBoolean(false);
    private static final int TRACE_DISTANCE = 16;
    private static final double SAMPLE_OFFSET = 0.2;
    private static final Object2BooleanOpenHashMap<Key> BLOCK_CACHE = new Object2BooleanOpenHashMap(16000);
    private static final ConcurrentMap<Key, CompletableFuture<Boolean>> INFLIGHT = new ConcurrentHashMap<Key, CompletableFuture<Boolean>>();
    private static ExecutorService tracerPool;
    private static ScheduledExecutorService timeoutChecker;
    private static final AtomicInteger PENDING;
    private static long lastCacheCleanup;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean shouldCullBlockFace(BlockGetter level, BlockPos pos, Direction face) {
        if (FALLBACK_MODE.get()) {
            return LeafCulling.checkSimpleConnection(level, pos.m_121945_(face), face);
        }
        long now = System.currentTimeMillis();
        if (now - lastCacheCleanup > 1000L) {
            Object2BooleanOpenHashMap<Key> object2BooleanOpenHashMap = BLOCK_CACHE;
            synchronized (object2BooleanOpenHashMap) {
                BLOCK_CACHE.clear();
            }
            lastCacheCleanup = now;
        }
        Key key = new Key(System.identityHashCode(level), pos.m_121878_(), (byte)face.ordinal());
        Object2BooleanOpenHashMap<Key> object2BooleanOpenHashMap = BLOCK_CACHE;
        synchronized (object2BooleanOpenHashMap) {
            if (BLOCK_CACHE.containsKey((Object)key)) {
                return BLOCK_CACHE.getBoolean((Object)key);
            }
        }
        BlockPos adjacentPos = pos.m_121945_(face);
        BlockState neighbor = level.m_8055_(adjacentPos);
        if (neighbor.m_60795_()) {
            Object2BooleanOpenHashMap<Key> object2BooleanOpenHashMap2 = BLOCK_CACHE;
            synchronized (object2BooleanOpenHashMap2) {
                BLOCK_CACHE.put((Object)key, false);
            }
            return false;
        }
        if (neighbor.m_60783_(level, adjacentPos, face.m_122424_()) || LeafCulling.checkSimpleConnection(level, adjacentPos)) {
            Object2BooleanOpenHashMap<Key> object2BooleanOpenHashMap3 = BLOCK_CACHE;
            synchronized (object2BooleanOpenHashMap3) {
                BLOCK_CACHE.put((Object)key, true);
            }
            return true;
        }
        BlockFaceOcclusionCuller.scheduleTrace(level, pos, face, key);
        return false;
    }

    private static void scheduleTrace(BlockGetter level, BlockPos pos, Direction face, Key key) {
        INFLIGHT.computeIfAbsent(key, k -> {
            CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
            Runnable work = () -> {
                try {
                    Vec3 dir;
                    Vec3 endCenter;
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    Vec3 startCenter = BlockFaceOcclusionCuller.getFaceCenter(pos, face);
                    boolean anyVisible = BlockFaceOcclusionCuller.traceVisibilityMultiSample(startCenter, endCenter = startCenter.m_82549_((dir = new Vec3((double)face.m_122429_(), (double)face.m_122430_(), (double)face.m_122431_())).m_82490_(16.0)), level, face);
                    boolean shouldCull = !anyVisible;
                    future.complete(shouldCull);
                }
                catch (Throwable t) {
                    future.completeExceptionally(t);
                }
                finally {
                    PENDING.decrementAndGet();
                }
            };
            if (PENDING.incrementAndGet() > 4096) {
                PENDING.decrementAndGet();
                future.complete(false);
            } else {
                Future<?> task = tracerPool.submit(work);
                timeoutChecker.schedule(() -> {
                    if (!future.isDone()) {
                        task.cancel(true);
                        future.complete(false);
                    }
                }, 25L, TimeUnit.MILLISECONDS);
            }
            future.whenComplete((res, err) -> {
                block10: {
                    try {
                        if (err != null) {
                            FALLBACK_MODE.set(true);
                            boolean fb = LeafCulling.checkSimpleConnection(level, pos.m_121945_(face));
                            Object2BooleanOpenHashMap<Key> object2BooleanOpenHashMap = BLOCK_CACHE;
                            synchronized (object2BooleanOpenHashMap) {
                                BLOCK_CACHE.put((Object)key, fb);
                                break block10;
                            }
                        }
                        Object2BooleanOpenHashMap<Key> object2BooleanOpenHashMap = BLOCK_CACHE;
                        synchronized (object2BooleanOpenHashMap) {
                            BLOCK_CACHE.put((Object)key, res);
                        }
                    }
                    finally {
                        INFLIGHT.remove(key);
                    }
                }
            });
            return future;
        });
    }

    private static boolean traceVisibilityMultiSample(Vec3 centerStart, Vec3 centerEnd, BlockGetter level, Direction face) {
        Vec3[] offsets;
        for (Vec3 off : offsets = BlockFaceOcclusionCuller.sampleOffsets(face)) {
            Vec3 e;
            if (Thread.interrupted()) {
                return true;
            }
            Vec3 s = centerStart.m_82549_(off);
            if (!BlockFaceOcclusionCuller.traceVisibility(s, e = centerEnd.m_82549_(off), level)) continue;
            return true;
        }
        return false;
    }

    private static boolean traceVisibility(Vec3 start, Vec3 end, BlockGetter level) {
        Vec3 direction = end.m_82546_(start);
        double distance = direction.m_82553_();
        if (distance < 0.001) {
            return true;
        }
        direction = direction.m_82541_();
        double stepSize = Math.min(0.25, Math.max(0.0625, distance / 32.0));
        int maxSteps = (int)Math.min(256.0, Math.ceil(distance / stepSize) + 2.0);
        BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos();
        Vec3 current = start;
        int steps = 0;
        while (steps++ < maxSteps && current.m_82554_(start) < distance) {
            if (Thread.interrupted()) {
                return true;
            }
            mpos.m_122169_(current.f_82479_, current.f_82480_, current.f_82481_);
            BlockState state = level.m_8055_((BlockPos)mpos);
            if (!state.m_60795_() && !state.m_60768_(level, (BlockPos)mpos).m_83281_() && state.m_60812_(level, (BlockPos)mpos).m_83215_().m_82338_((BlockPos)mpos).m_82390_(current)) {
                return false;
            }
            current = current.m_82549_(direction.m_82490_(stepSize));
        }
        return true;
    }

    private static Vec3[] sampleOffsets(Direction face) {
        switch (face) {
            case UP: 
            case DOWN: {
                return new Vec3[]{Vec3.f_82478_, new Vec3(0.2, 0.0, 0.0), new Vec3(-0.2, 0.0, 0.0), new Vec3(0.0, 0.0, 0.2), new Vec3(0.0, 0.0, -0.2)};
            }
            case NORTH: 
            case SOUTH: {
                return new Vec3[]{Vec3.f_82478_, new Vec3(0.2, 0.0, 0.0), new Vec3(-0.2, 0.0, 0.0), new Vec3(0.0, 0.2, 0.0), new Vec3(0.0, -0.2, 0.0)};
            }
        }
        return new Vec3[]{Vec3.f_82478_, new Vec3(0.0, 0.2, 0.0), new Vec3(0.0, -0.2, 0.0), new Vec3(0.0, 0.0, 0.2), new Vec3(0.0, 0.0, -0.2)};
    }

    private static Vec3 getFaceCenter(BlockPos pos, Direction face) {
        return new Vec3((double)pos.m_123341_() + 0.5 + (double)face.m_122429_() * 0.501, (double)pos.m_123342_() + 0.5 + (double)face.m_122430_() * 0.501, (double)pos.m_123343_() + 0.5 + (double)face.m_122431_() * 0.501);
    }

    public static boolean isInFallbackMode() {
        return FALLBACK_MODE.get();
    }

    private static synchronized void initExecutors() {
        if (tracerPool == null) {
            int cpus = Math.max(2, Runtime.getRuntime().availableProcessors());
            tracerPool = new ThreadPoolExecutor(Math.max(1, cpus / 4), Math.max(2, cpus / 2), 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(4096), new NamedThreadFactory("Tritium-occl-trace", true), new ThreadPoolExecutor.DiscardPolicy());
        }
        if (timeoutChecker == null) {
            timeoutChecker = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("Tritium-occl-timeout", true));
        }
    }

    static {
        PENDING = new AtomicInteger();
        lastCacheCleanup = System.currentTimeMillis();
        BlockFaceOcclusionCuller.initExecutors();
    }

    private record Key(int levelId, long pos, byte face) {
    }

    private static final class NamedThreadFactory
    implements ThreadFactory {
        private final String baseName;
        private final boolean daemon;
        private final AtomicInteger idx = new AtomicInteger(1);

        private NamedThreadFactory(String baseName, boolean daemon) {
            this.baseName = Objects.requireNonNull(baseName);
            this.daemon = daemon;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, this.baseName + "-" + this.idx.getAndIncrement());
            t.setDaemon(this.daemon);
            t.setPriority(4);
            return t;
        }
    }
}

