/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.mixin.client.renderer.culling;

import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import org.craftamethyst.tritium.client.TritiumClient;
import org.craftamethyst.tritium.config.TritiumConfigBase;
import org.craftamethyst.tritium.cull.CullCache;
import org.craftamethyst.tritium.helper.EntityTickHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityRenderDispatcher.class})
public abstract class EntityRenderDispatcherMixin {
    @Inject(method={"shouldRender"}, at={@At(value="HEAD")}, cancellable=true)
    private <E extends Entity> void tritium$earlyCullingCheck(E entity, Frustum frustum, double camX, double camY, double camZ, CallbackInfoReturnable<Boolean> cir) {
        CullCache.CullResult cached;
        if (!TritiumConfigBase.Entities.EntityOpt.ite) {
            return;
        }
        TritiumClient client = TritiumClient.instance;
        if (client == null) {
            return;
        }
        if (client.getCullCache() != null && (cached = client.getCullCache().checkEntity(entity)).isCached() && cached.isCulled()) {
            cir.setReturnValue((Object)false);
            return;
        }
        if (EntityTickHelper.shouldSkipTick(entity)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"shouldRender"}, at={@At(value="TAIL")}, cancellable=true)
    private <E extends Entity> void tritium$skipCulledOrTickSkippedEntity(E entity, Frustum frustum, double camX, double camY, double camZ, CallbackInfoReturnable<Boolean> cir) {
        if (!TritiumConfigBase.Entities.EntityOpt.ite) {
            return;
        }
        if (!((Boolean)cir.getReturnValue()).booleanValue()) {
            return;
        }
        if (EntityTickHelper.shouldSkipTick(entity) || TritiumClient.instance != null && TritiumClient.instance.shouldSkipEntity(entity)) {
            cir.setReturnValue((Object)false);
        }
    }
}

