/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.mixin.entity.stack.item;

import java.util.Comparator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.craftamethyst.tritium.config.TritiumConfigBase;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemEntity.class})
public abstract class ItemEntityMixin {
    @Unique
    private static final int MERGE_COOLDOWN_TICKS = 5;
    @Unique
    private static final int DEFAULT_MAX_STACK = 2147483547;
    @Unique
    private int tritium$lastMergeTick = -1;
    @Unique
    private int tritium$lastDisplayUpdateTick = -1;

    @Shadow
    public abstract ItemStack m_32055_();

    @Shadow
    public abstract void m_32045_(ItemStack var1);

    @Shadow
    public abstract void m_32064_();

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void onTick(CallbackInfo ci) {
        if (!this.tritium$shouldProcess()) {
            return;
        }
        ItemEntity self = (ItemEntity)this;
        if (this.tritium$shouldAttemptMerge(self)) {
            this.tritium$lastMergeTick = (int)self.m_9236_().m_46467_();
            this.tritium$tryMergeItems(self);
        }
    }

    @Inject(method={"setItem"}, at={@At(value="TAIL")})
    private void onSetItem(ItemStack stack, CallbackInfo ci) {
        if (!this.tritium$shouldProcess()) {
            return;
        }
        ItemEntity self = (ItemEntity)this;
        this.tritium$updateStackDisplay(self);
        this.tritium$lastDisplayUpdateTick = (int)self.m_9236_().m_46467_();
    }

    @Inject(method={"<init>(Lnet/minecraft/world/level/Level;DDDLnet/minecraft/world/item/ItemStack;)V"}, at={@At(value="TAIL")})
    private void onConstructor(Level level, double x, double y, double z, ItemStack stack, CallbackInfo ci) {
        if (!this.tritium$shouldProcess()) {
            return;
        }
        ItemEntity self = (ItemEntity)this;
        this.tritium$updateStackDisplay(self);
        this.tritium$lastDisplayUpdateTick = (int)self.m_9236_().m_46467_();
    }

    @Inject(method={"<init>(Lnet/minecraft/world/level/Level;DDDLnet/minecraft/world/item/ItemStack;DDD)V"}, at={@At(value="TAIL")})
    private void onConstructorWithVelocity(Level level, double x, double y, double z, ItemStack stack, double dx, double dy, double dz, CallbackInfo ci) {
        if (!this.tritium$shouldProcess()) {
            return;
        }
        ItemEntity self = (ItemEntity)this;
        this.tritium$updateStackDisplay(self);
        this.tritium$lastDisplayUpdateTick = (int)self.m_9236_().m_46467_();
    }

    @Unique
    private boolean tritium$shouldProcess() {
        return TritiumConfigBase.Entities.EntityStacking.enable;
    }

    @Unique
    private boolean tritium$shouldAttemptMerge(ItemEntity self) {
        long gameTime = self.m_9236_().m_46467_();
        return this.tritium$lastMergeTick == -1 || gameTime - (long)this.tritium$lastMergeTick >= 5L;
    }

    @Unique
    private void tritium$tryMergeItems(ItemEntity self) {
        if (!TritiumConfigBase.Entities.EntityStacking.enable) {
            return;
        }
        ItemStack stack = self.m_32055_();
        int maxStack = this.tritium$getEffectiveMaxStackSize();
        if (stack.m_41613_() >= maxStack) {
            return;
        }
        List<ItemEntity> nearby = this.tritium$findMergeableItems(self);
        if (nearby.isEmpty()) {
            return;
        }
        this.tritium$performMerge(self, stack, maxStack, nearby);
    }

    @Unique
    private int tritium$getEffectiveMaxStackSize() {
        int configMax = TritiumConfigBase.Entities.EntityStacking.maxStackSize;
        return configMax > 0 ? configMax : 2147483547;
    }

    @Unique
    private List<ItemEntity> tritium$findMergeableItems(ItemEntity self) {
        double mergeDistance = TritiumConfigBase.Entities.EntityStacking.mergeDistance;
        int listMode = TritiumConfigBase.Entities.EntityStacking.listMode;
        List<String> itemList = TritiumConfigBase.Entities.EntityStacking.itemList;
        self.m_32055_();
        List nearby = self.m_9236_().m_6443_(ItemEntity.class, self.m_20191_().m_82400_(mergeDistance), e -> this.tritium$isValidMergeTarget(self, (ItemEntity)e, listMode, (List<? extends String>)itemList));
        nearby.sort(Comparator.comparingDouble(arg_0 -> ((ItemEntity)self).m_20280_(arg_0)));
        return nearby;
    }

    @Unique
    private void tritium$performMerge(ItemEntity self, ItemStack stack, int maxStack, List<ItemEntity> nearby) {
        int remainingSpace = maxStack - stack.m_41613_();
        for (ItemEntity other : nearby) {
            if (remainingSpace <= 0) break;
            ItemStack otherStack = other.m_32055_();
            int transfer = Math.min(otherStack.m_41613_(), remainingSpace);
            stack.m_41769_(transfer);
            self.m_32045_(stack);
            self.m_32064_();
            this.tritium$handleOtherStackAfterTransfer(other, otherStack, transfer);
            remainingSpace -= transfer;
        }
    }

    @Unique
    private void tritium$handleOtherStackAfterTransfer(ItemEntity other, ItemStack otherStack, int transfer) {
        if (otherStack.m_41613_() == transfer) {
            other.m_146870_();
        } else {
            otherStack.m_41774_(transfer);
            other.m_32045_(otherStack);
            this.tritium$updateStackDisplay(other);
        }
    }

    @Unique
    private void tritium$updateStackDisplay(ItemEntity entity) {
        if (!TritiumConfigBase.Entities.EntityStacking.enable || !TritiumConfigBase.Entities.EntityStacking.showStackCount) {
            this.tritium$clearDisplay(entity);
            return;
        }
        ItemStack stack = entity.m_32055_();
        if (stack.m_41613_() > 1) {
            this.tritium$setStackCountDisplay(entity, stack.m_41613_());
        } else {
            this.tritium$clearDisplay(entity);
        }
    }

    @Unique
    private void tritium$setStackCountDisplay(ItemEntity entity, int count) {
        String currentText;
        Component currentName = entity.m_7770_();
        if (currentName != null && (currentText = currentName.getString()).startsWith("\u00d7") && currentText.length() > 1) {
            try {
                int currentCount = Integer.parseInt(currentText.substring(1));
                if (currentCount == count) {
                    return;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        MutableComponent countText = Component.m_237113_((String)("\u00d7" + count)).m_130940_(ChatFormatting.DARK_GREEN).m_130940_(ChatFormatting.BOLD);
        entity.m_6593_((Component)countText);
        entity.m_20340_(true);
    }

    @Unique
    private void tritium$clearDisplay(ItemEntity entity) {
        entity.m_6593_(null);
        entity.m_20340_(false);
    }

    @Unique
    private boolean tritium$isValidMergeTarget(ItemEntity self, ItemEntity other, int listMode, List<? extends String> itemList) {
        ItemStack otherStack;
        if (self == other || other.m_213877_()) {
            return false;
        }
        ItemStack selfStack = self.m_32055_();
        return this.tritium$isSameItem(selfStack, otherStack = other.m_32055_()) && this.tritium$isMergeAllowed(otherStack, listMode, itemList) && (!TritiumConfigBase.Entities.EntityStacking.lockMaxedStacks || otherStack.m_41613_() < this.tritium$getEffectiveMaxStackSize()) && self.m_32055_().m_41613_() + other.m_32055_().m_41613_() <= self.m_32055_().m_41741_();
    }

    @Unique
    private boolean tritium$isSameItem(ItemStack a, ItemStack b) {
        return ItemStack.m_150942_((ItemStack)a, (ItemStack)b);
    }

    @Unique
    private boolean tritium$isMergeAllowed(ItemStack stack, int listMode, List<? extends String> itemList) {
        if (listMode == 0) {
            return true;
        }
        ResourceLocation id = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_());
        boolean inList = itemList.contains(id.toString());
        return listMode == 1 == inList;
    }
}

