/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.mixin.create;

import java.util.function.BooleanSupplier;
import net.minecraft.server.MinecraftServer;
import org.craftamethyst.tritium.config.TritiumConfigBase;
import org.craftamethyst.tritium.util.RailOffloaderHub;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MinecraftServer.class})
abstract class ServerLifecycleHook {
    ServerLifecycleHook() {
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void onConstruct(CallbackInfo ci) {
        if (TritiumConfigBase.TechOptimizations.CreateOptimizations.enableRailOffloading) {
            RailOffloaderHub.initialize();
        }
    }

    @Inject(method={"tickServer"}, at={@At(value="HEAD")})
    private void tickHead(BooleanSupplier sup, CallbackInfo ci) {
        if (TritiumConfigBase.TechOptimizations.CreateOptimizations.enableRailOffloading) {
            RailOffloaderHub.onTickStart((MinecraftServer)this);
        }
    }

    @Inject(method={"tickServer"}, at={@At(value="TAIL")})
    private void tickTail(BooleanSupplier sup, CallbackInfo ci) {
        if (TritiumConfigBase.TechOptimizations.CreateOptimizations.enableRailOffloading) {
            RailOffloaderHub.onTickEnd();
        }
    }

    @Inject(method={"stopServer"}, at={@At(value="HEAD")})
    private void onStop(CallbackInfo ci) {
        if (TritiumConfigBase.TechOptimizations.CreateOptimizations.enableRailOffloading) {
            RailOffloaderHub.shutdown();
        }
    }
}

