/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.mixin.jigsaw;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.phys.AABB;
import org.craftamethyst.tritium.config.TritiumConfigBase;
import org.craftamethyst.tritium.octree.BoxOctree;
import org.craftamethyst.tritium.util.OctreeHolder;
import org.craftamethyst.tritium.util.RotationFailMask;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={JigsawPlacement.class})
public class JigsawPlacementMixin {
    @Inject(method={"addPieces(Lnet/minecraft/world/level/levelgen/structure/Structure$GenerationContext;Lnet/minecraft/core/Holder;Ljava/util/Optional;ILnet/minecraft/core/BlockPos;ZLjava/util/Optional;I)Ljava/util/Optional;"}, at={@At(value="HEAD")}, require=1)
    private static void onAddPiecesStart(Structure.GenerationContext context, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int maxDepth, BlockPos pos, boolean useExpansionHack, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter, CallbackInfoReturnable<Optional<Structure.GenerationStub>> cir) {
        if (TritiumConfigBase.ServerPerformance.JigsawOptimizations.enableJigsawOptimizations && TritiumConfigBase.ServerPerformance.JigsawOptimizations.enableOctreeCollisionDetection && OctreeHolder.get() == null) {
            OctreeHolder.set(new BoxOctree(new AABB(-300.0, -64.0, -300.0, 300.0, 256.0, 300.0)));
        }
    }

    @Inject(method={"addPieces(Lnet/minecraft/world/level/levelgen/structure/Structure$GenerationContext;Lnet/minecraft/core/Holder;Ljava/util/Optional;ILnet/minecraft/core/BlockPos;ZLjava/util/Optional;I)Ljava/util/Optional;"}, at={@At(value="RETURN")}, require=1)
    private static void onAddPiecesEnd(Structure.GenerationContext context, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int maxDepth, BlockPos pos, boolean useExpansionHack, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter, CallbackInfoReturnable<Optional<Structure.GenerationStub>> cir) {
        if (TritiumConfigBase.ServerPerformance.JigsawOptimizations.enableJigsawOptimizations && TritiumConfigBase.ServerPerformance.JigsawOptimizations.enableOctreeCollisionDetection) {
            OctreeHolder.clear();
            RotationFailMask.clear();
        }
    }
}

