/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.mixin.jigsaw;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.craftamethyst.tritium.config.TritiumConfigBase;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={StructureTemplate.class})
public class StructureBlockEntityMixin {
    @Inject(method={"processBlockInfos"}, at={@At(value="HEAD")})
    private static void tritium$filterBlocksOutsideBox(ServerLevelAccessor level, BlockPos offset, BlockPos pos, StructurePlaceSettings settings, List<StructureTemplate.StructureBlockInfo> blockInfos, CallbackInfoReturnable<List<StructureTemplate.StructureBlockInfo>> cir) {
        if (!TritiumConfigBase.ServerPerformance.JigsawOptimizations.enableJigsawOptimizations || !TritiumConfigBase.ServerPerformance.JigsawOptimizations.enableStructureBlockFiltering) {
            return;
        }
        BoundingBox box = settings.m_74409_();
        if (box == null) {
            return;
        }
        blockInfos.removeIf(info -> {
            BlockPos target = StructureTemplate.m_74563_((StructurePlaceSettings)settings, (BlockPos)info.f_74675_()).m_121955_((Vec3i)offset);
            return !box.m_71051_((Vec3i)target);
        });
    }

    @Inject(method={"processBlockInfos"}, at={@At(value="RETURN")}, cancellable=true)
    private static void tritium$filterAgain(ServerLevelAccessor level, BlockPos offset, BlockPos pos, StructurePlaceSettings settings, List<StructureTemplate.StructureBlockInfo> original, CallbackInfoReturnable<List<StructureTemplate.StructureBlockInfo>> cir) {
        if (!TritiumConfigBase.ServerPerformance.JigsawOptimizations.enableJigsawOptimizations || !TritiumConfigBase.ServerPerformance.JigsawOptimizations.enableStructureBlockFiltering) {
            return;
        }
        List firstCut = (List)cir.getReturnValue();
        if (firstCut == null) {
            return;
        }
        BoundingBox box = settings.m_74409_();
        if (box == null) {
            return;
        }
        ArrayList<StructureTemplate.StructureBlockInfo> secondCut = new ArrayList<StructureTemplate.StructureBlockInfo>(firstCut.size());
        for (StructureTemplate.StructureBlockInfo info : firstCut) {
            if (!box.m_71051_((Vec3i)info.f_74675_())) continue;
            secondCut.add(info);
        }
        cir.setReturnValue(secondCut);
    }
}

