/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.mixin.memory.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.lang.reflect.Constructor;
import java.util.ArrayDeque;
import java.util.Deque;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PoseStack.class})
public class PoseStackMixin {
    private final Deque<PoseStack.Pose> pool = new ArrayDeque<PoseStack.Pose>();
    @Shadow
    @Final
    private Deque<PoseStack.Pose> f_85834_;

    private static PoseStack.Pose createPose(Matrix4f pose, Matrix3f normal) {
        try {
            Constructor ctr = PoseStack.Pose.class.getDeclaredConstructor(Matrix4f.class, Matrix3f.class);
            ctr.setAccessible(true);
            return (PoseStack.Pose)ctr.newInstance(pose, normal);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create PoseStack.Pose", e);
        }
    }

    @Inject(method={"pushPose"}, at={@At(value="HEAD")}, cancellable=true)
    private void onPush(CallbackInfo ci) {
        if (this.f_85834_.isEmpty()) {
            return;
        }
        PoseStack.Pose top = this.f_85834_.getLast();
        PoseStack.Pose reused = this.pool.pollLast();
        if (reused == null) {
            Matrix4f newPos = new Matrix4f().set((Matrix4fc)top.m_252922_());
            Matrix3f newNorm = new Matrix3f().set((Matrix3fc)top.m_252943_());
            reused = PoseStackMixin.createPose(newPos, newNorm);
        } else {
            reused.m_252922_().set((Matrix4fc)top.m_252922_());
            reused.m_252943_().set((Matrix3fc)top.m_252943_());
        }
        this.f_85834_.addLast(reused);
        ci.cancel();
    }

    @Inject(method={"popPose"}, at={@At(value="HEAD")}, cancellable=true)
    private void onPop(CallbackInfo ci) {
        this.pool.addLast(this.f_85834_.removeLast());
        ci.cancel();
    }
}

