/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium;

import me.zcraft.tconfig.config.TritiumConfig;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import org.craftamethyst.tritium.TritiumCommon;
import org.craftamethyst.tritium.TritiumConfigScreenFactory;

public class TritiumConfigScreenReg {
    public static void registerConfigScreen() {
        try {
            ModContainer currentMod = ModLoadingContext.get().getActiveContainer();
            String modId = currentMod.getModId();
            TritiumConfigScreenReg.registerConfigScreenInternal(modId, TritiumConfig.getConfig(modId));
        }
        catch (Exception e) {
            TritiumCommon.LOG.error("Failed to auto-register config screen for current mod", (Throwable)e);
        }
    }

    public static void registerConfigScreen(String modId) {
        try {
            TritiumConfigScreenReg.registerConfigScreenInternal(modId, TritiumConfig.getConfig(modId));
        }
        catch (Exception e) {
            TritiumCommon.LOG.error("Failed to register config screen for mod: {}", (Object)modId, (Object)e);
        }
    }

    public static void registerConfigScreen(TritiumConfig config) {
        try {
            TritiumConfigScreenReg.registerConfigScreenInternal(config.getModId(), config);
        }
        catch (Exception e) {
            TritiumCommon.LOG.error("Failed to register config screen for config: {}", (Object)config.getConfigClass().getName(), (Object)e);
        }
    }

    private static void registerConfigScreenInternal(String modId, TritiumConfig config) {
        if (config == null) {
            TritiumCommon.LOG.warn("No configuration found for mod: {}. Call TritiumConfig.register() first.", (Object)modId);
            return;
        }
        if (!config.isClientEnvironment()) {
            TritiumCommon.LOG.debug("Skipping config screen registration for mod {} in server environment", (Object)modId);
            return;
        }
        TritiumConfigScreenReg.registerSingleConfigScreen(modId, config);
    }

    private static void registerSingleConfigScreen(String modId, TritiumConfig config) {
        ModList.get().getModContainerById(modId).ifPresent(container -> {
            ModLoadingContext.get().registerExtensionPoint(IConfigScreenFactory.class, () -> (container1, parent) -> TritiumConfigScreenFactory.createConfigScreen(parent, config));
            TritiumCommon.LOG.info("Config screen registered for mod: {}", (Object)modId);
        });
    }
}

