/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.cull;

import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.craftamethyst.tritium.cull.CullCache;
import org.craftamethyst.tritium.cull.OcclusionProvider;
import org.craftamethyst.tritium.cull.iface.BlockEntityVisibility;
import org.craftamethyst.tritium.cull.iface.EntityVisibility;
import org.craftamethyst.tritium.libs.com.logisticscraft.occlusionculling.OcclusionCullingInstance;
import org.craftamethyst.tritium.libs.com.logisticscraft.occlusionculling.util.Vec3d;

public class AABBCullingManager {
    private static final double HITBOX_LIMIT = 10.0;
    private static final double MANHATTAN_THRESHOLD = 1.732;
    private static final long CAMERA_UPDATE_INTERVAL = 50L;
    private static final long DISTANCE_UPDATE_INTERVAL = 1000L;
    private static final double RESET_DISTANCE_THRESHOLD = 2.0;
    private static final long MIN_RESET_INTERVAL = 1000L;
    private final OcclusionCullingInstance occlusionCulling;
    private final CullCache cullCache = new CullCache();
    private final Minecraft mc;
    private final AABBOBJ reusableAABB = new AABBOBJ(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private final Vec3d reusableAabbMin = new Vec3d(0.0, 0.0, 0.0);
    private final Vec3d reusableAabbMax = new Vec3d(0.0, 0.0, 0.0);
    private final Vec3d reusableCamera = new Vec3d(0.0, 0.0, 0.0);
    private Vec3 cachedCameraPos = Vec3.ZERO;
    private double cachedCullingDistance = 128.0;
    private long lastCameraUpdate = 0L;
    private long lastDistanceUpdate = 0L;
    private Vec3 lastResetCameraPos = Vec3.ZERO;
    private long lastResetTime = 0L;

    public AABBCullingManager() {
        this.mc = Minecraft.getInstance();
        this.occlusionCulling = new OcclusionCullingInstance(64, new OcclusionProvider());
    }

    public boolean shouldCullEntity(Entity entity) {
        EntityVisibility cullable;
        if (this.isPlayerSprinting()) {
            return false;
        }
        if (entity == null) {
            return false;
        }
        if (this.mc.level == null) {
            return false;
        }
        CullCache.CullResult cached = this.cullCache.checkEntity(entity);
        if (cached.isCached()) {
            return cached.isCulled();
        }
        if (entity instanceof EntityVisibility && (cullable = (EntityVisibility)entity).tritium$isForcedVisible()) {
            this.cullCache.cacheEntity(entity, false);
            return false;
        }
        if (!this.needsDetailedEntityCheck(entity)) {
            this.cullCache.cacheEntity(entity, false);
            return false;
        }
        Vec3 cameraPos = this.getCachedCameraPos();
        double cullingDistance = this.getCachedCullingDistance();
        if (this.isWithinDistanceOptimized(entity.getEyePosition(), cameraPos, cullingDistance)) {
            this.cullCache.cacheEntity(entity, true);
            return true;
        }
        AABB boundingBox = entity.getBoundingBox();
        if (this.isLargeEntity(boundingBox)) {
            this.cullCache.cacheEntity(entity, false);
            return false;
        }
        boolean visible = this.performOcclusionCheck(boundingBox, cameraPos);
        boolean shouldCull = !visible;
        this.cullCache.cacheEntity(entity, shouldCull);
        return shouldCull;
    }

    public boolean shouldCullBlockEntity(BlockEntity blockEntity) {
        BlockEntityVisibility cullable;
        if (this.isPlayerSprinting()) {
            return false;
        }
        if (blockEntity == null) {
            return false;
        }
        if (this.mc.level == null) {
            return false;
        }
        CullCache.CullResult cached = this.cullCache.checkBlockEntity(blockEntity);
        if (cached.isCached()) {
            return cached.isCulled();
        }
        if (blockEntity instanceof BlockEntityVisibility && (cullable = (BlockEntityVisibility)blockEntity).tritium$isForcedVisible()) {
            this.cullCache.cacheBlockEntity(blockEntity, false);
            return false;
        }
        Vec3 cameraPos = this.getCachedCameraPos();
        double cullingDistance = this.getCachedCullingDistance();
        if (this.isWithinDistanceOptimized(blockEntity.getBlockPos().getCenter(), cameraPos, cullingDistance)) {
            this.cullCache.cacheBlockEntity(blockEntity, true);
            return true;
        }
        BlockPos pos = blockEntity.getBlockPos();
        this.reusableAABB.set(pos.getX(), pos.getY(), pos.getZ(), pos.getX() + 1, pos.getY() + 1, pos.getZ() + 1);
        boolean visible = this.performOcclusionCheck(this.reusableAABB, cameraPos);
        boolean shouldCull = !visible;
        this.cullCache.cacheBlockEntity(blockEntity, shouldCull);
        return shouldCull;
    }

    private boolean needsDetailedEntityCheck(Entity entity) {
        ArmorStand armorStand;
        if (entity.isInvisible()) {
            return false;
        }
        if (entity == this.mc.getCameraEntity()) {
            return false;
        }
        if (entity == this.mc.player) {
            return false;
        }
        if (entity.isSpectator()) {
            return false;
        }
        if (entity.isVehicle()) {
            return false;
        }
        if (entity.isPassenger()) {
            return false;
        }
        return !(entity instanceof ArmorStand) || !(armorStand = (ArmorStand)entity).isMarker();
    }

    private boolean isWithinDistanceOptimized(Vec3 entityPos, Vec3 cameraPos, double distance) {
        double manhattan = Math.abs(entityPos.x - cameraPos.x) + Math.abs(entityPos.y - cameraPos.y) + Math.abs(entityPos.z - cameraPos.z);
        if (manhattan > distance * 1.732) {
            return true;
        }
        double dx = entityPos.x - cameraPos.x;
        double dy = entityPos.y - cameraPos.y;
        double dz = entityPos.z - cameraPos.z;
        double distanceSq = dx * dx + dy * dy + dz * dz;
        return !(distanceSq <= distance * distance);
    }

    private boolean performOcclusionCheck(AABB boundingBox, Vec3 cameraPos) {
        this.reusableAabbMin.set(boundingBox.minX, boundingBox.minY, boundingBox.minZ);
        this.reusableAabbMax.set(boundingBox.maxX, boundingBox.maxY, boundingBox.maxZ);
        this.reusableCamera.set(cameraPos.x, cameraPos.y, cameraPos.z);
        return this.occlusionCulling.isAABBVisible(this.reusableAabbMin, this.reusableAabbMax, this.reusableCamera);
    }

    private boolean performOcclusionCheck(AABBOBJ boundingBox, Vec3 cameraPos) {
        this.reusableAabbMin.set(boundingBox.minX, boundingBox.minY, boundingBox.minZ);
        this.reusableAabbMax.set(boundingBox.maxX, boundingBox.maxY, boundingBox.maxZ);
        this.reusableCamera.set(cameraPos.x, cameraPos.y, cameraPos.z);
        return this.occlusionCulling.isAABBVisible(this.reusableAabbMin, this.reusableAabbMax, this.reusableCamera);
    }

    private boolean isLargeEntity(AABB boundingBox) {
        return boundingBox.getXsize() > 10.0 || boundingBox.getYsize() > 10.0 || boundingBox.getZsize() > 10.0;
    }

    private Vec3 getCachedCameraPos() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastCameraUpdate > 50L) {
            Camera mainCamera = this.mc.gameRenderer.getMainCamera();
            this.cachedCameraPos = mainCamera.getPosition();
            this.lastCameraUpdate = currentTime;
        }
        return this.cachedCameraPos;
    }

    private double getCachedCullingDistance() {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastDistanceUpdate > 1000L) {
            this.cachedCullingDistance = this.mc.level == null ? 128.0 : (double)(this.mc.level.getServerSimulationDistance() * 16) * 1.1;
            this.lastDistanceUpdate = currentTime;
        }
        return this.cachedCullingDistance;
    }

    public void updateCameraPosition() {
        Vec3 currentCameraPos = this.getCachedCameraPos();
        long currentTime = System.currentTimeMillis();
        boolean shouldReset = false;
        if (this.lastResetCameraPos == Vec3.ZERO) {
            shouldReset = true;
        } else {
            double distanceMoved = currentCameraPos.distanceTo(this.lastResetCameraPos);
            if (distanceMoved > 2.0) {
                shouldReset = true;
            }
        }
        if (currentTime - this.lastResetTime > 1000L) {
            shouldReset = true;
        }
        if (shouldReset) {
            this.occlusionCulling.resetCache();
            this.lastResetCameraPos = currentCameraPos;
            this.lastResetTime = currentTime;
        }
        this.lastCameraUpdate = 0L;
    }

    public void dispose() {
        this.cullCache.clear();
        this.lastResetCameraPos = Vec3.ZERO;
        this.lastResetTime = 0L;
    }

    private boolean isPlayerSprinting() {
        return this.mc.player != null && this.mc.player.isSprinting();
    }

    public double getCurrentCullingDistance() {
        return this.cachedCullingDistance;
    }

    public OcclusionCullingInstance getOcclusionCulling() {
        return this.occlusionCulling;
    }

    public void forceResetCache() {
        this.occlusionCulling.resetCache();
        this.lastResetCameraPos = this.getCachedCameraPos();
        this.lastResetTime = System.currentTimeMillis();
    }

    public static class AABBOBJ {
        public double minX;
        public double minY;
        public double minZ;
        public double maxX;
        public double maxY;
        public double maxZ;

        public AABBOBJ(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
            this.set(minX, minY, minZ, maxX, maxY, maxZ);
        }

        public void set(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
            this.minX = minX;
            this.minY = minY;
            this.minZ = minZ;
            this.maxX = maxX;
            this.maxY = maxY;
            this.maxZ = maxZ;
        }

        public double getXsize() {
            return this.maxX - this.minX;
        }

        public double getYsize() {
            return this.maxY - this.minY;
        }

        public double getZsize() {
            return this.maxZ - this.minZ;
        }
    }
}

