/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.cull;

import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.craftamethyst.tritium.cull.LeafCulling;
import org.jetbrains.annotations.NotNull;

public final class BlockFaceOcclusionCuller {
    private static final AtomicBoolean FALLBACK_MODE = new AtomicBoolean(false);
    private static final int TRACE_DISTANCE = 16;
    private static final double SAMPLE_OFFSET = 0.2;
    private static final Object2BooleanOpenHashMap<Key> BLOCK_CACHE = new Object2BooleanOpenHashMap(16000);
    private static final ConcurrentMap<Key, CompletableFuture<Boolean>> INFLIGHT = new ConcurrentHashMap<Key, CompletableFuture<Boolean>>();
    private static ExecutorService tracerPool;
    private static ScheduledExecutorService timeoutChecker;
    private static final AtomicInteger PENDING;
    private static long lastCacheCleanup;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean shouldCullBlockFace(BlockGetter level, BlockPos pos, Direction face) {
        if (FALLBACK_MODE.get()) {
            return LeafCulling.checkSimpleConnection(level, pos.relative(face), face);
        }
        long now = System.currentTimeMillis();
        if (now - lastCacheCleanup > 1000L) {
            Object2BooleanOpenHashMap<Key> object2BooleanOpenHashMap = BLOCK_CACHE;
            synchronized (object2BooleanOpenHashMap) {
                BLOCK_CACHE.clear();
            }
            lastCacheCleanup = now;
        }
        Key key = new Key(System.identityHashCode(level), pos.asLong(), (byte)face.ordinal());
        Object2BooleanOpenHashMap<Key> object2BooleanOpenHashMap = BLOCK_CACHE;
        synchronized (object2BooleanOpenHashMap) {
            if (BLOCK_CACHE.containsKey((Object)key)) {
                return BLOCK_CACHE.getBoolean((Object)key);
            }
        }
        BlockPos adjacentPos = pos.relative(face);
        BlockState neighbor = level.getBlockState(adjacentPos);
        if (neighbor.isAir()) {
            Object2BooleanOpenHashMap<Key> object2BooleanOpenHashMap2 = BLOCK_CACHE;
            synchronized (object2BooleanOpenHashMap2) {
                BLOCK_CACHE.put((Object)key, false);
            }
            return false;
        }
        if (neighbor.isFaceSturdy(level, adjacentPos, face.getOpposite()) || LeafCulling.checkSimpleConnection(level, adjacentPos)) {
            Object2BooleanOpenHashMap<Key> object2BooleanOpenHashMap3 = BLOCK_CACHE;
            synchronized (object2BooleanOpenHashMap3) {
                BLOCK_CACHE.put((Object)key, true);
            }
            return true;
        }
        BlockFaceOcclusionCuller.scheduleTrace(level, pos, face, key);
        return false;
    }

    private static void scheduleTrace(BlockGetter level, BlockPos pos, Direction face, Key key) {
        INFLIGHT.computeIfAbsent(key, k -> {
            CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
            Runnable work = () -> {
                try {
                    Vec3 dir;
                    Vec3 endCenter;
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    Vec3 startCenter = BlockFaceOcclusionCuller.getFaceCenter(pos, face);
                    boolean anyVisible = BlockFaceOcclusionCuller.traceVisibilityMultiSample(startCenter, endCenter = startCenter.add((dir = new Vec3((double)face.getStepX(), (double)face.getStepY(), (double)face.getStepZ())).scale(16.0)), level, face);
                    boolean shouldCull = !anyVisible;
                    future.complete(shouldCull);
                }
                catch (Throwable t) {
                    future.completeExceptionally(t);
                }
                finally {
                    PENDING.decrementAndGet();
                }
            };
            if (PENDING.incrementAndGet() > 4096) {
                PENDING.decrementAndGet();
                future.complete(false);
            } else {
                Future<?> task = tracerPool.submit(work);
                timeoutChecker.schedule(() -> {
                    if (!future.isDone()) {
                        task.cancel(true);
                        future.complete(false);
                    }
                }, 25L, TimeUnit.MILLISECONDS);
            }
            future.whenComplete((res, err) -> {
                block10: {
                    try {
                        if (err != null) {
                            FALLBACK_MODE.set(true);
                            boolean fb = LeafCulling.checkSimpleConnection(level, pos.relative(face));
                            Object2BooleanOpenHashMap<Key> object2BooleanOpenHashMap = BLOCK_CACHE;
                            synchronized (object2BooleanOpenHashMap) {
                                BLOCK_CACHE.put((Object)key, fb);
                                break block10;
                            }
                        }
                        Object2BooleanOpenHashMap<Key> object2BooleanOpenHashMap = BLOCK_CACHE;
                        synchronized (object2BooleanOpenHashMap) {
                            BLOCK_CACHE.put((Object)key, res);
                        }
                    }
                    finally {
                        INFLIGHT.remove(key);
                    }
                }
            });
            return future;
        });
    }

    private static boolean traceVisibilityMultiSample(Vec3 centerStart, Vec3 centerEnd, BlockGetter level, Direction face) {
        Vec3[] offsets;
        for (Vec3 off : offsets = BlockFaceOcclusionCuller.sampleOffsets(face)) {
            Vec3 e;
            if (Thread.interrupted()) {
                return true;
            }
            Vec3 s = centerStart.add(off);
            if (!BlockFaceOcclusionCuller.traceVisibility(s, e = centerEnd.add(off), level)) continue;
            return true;
        }
        return false;
    }

    private static boolean traceVisibility(Vec3 start, Vec3 end, BlockGetter level) {
        Vec3 direction = end.subtract(start);
        double distance = direction.length();
        if (distance < 0.001) {
            return true;
        }
        direction = direction.normalize();
        double stepSize = Math.min(0.25, Math.max(0.0625, distance / 32.0));
        int maxSteps = (int)Math.min(256.0, Math.ceil(distance / stepSize) + 2.0);
        BlockPos.MutableBlockPos mpos = new BlockPos.MutableBlockPos();
        Vec3 current = start;
        int steps = 0;
        while (steps++ < maxSteps && current.distanceTo(start) < distance) {
            if (Thread.interrupted()) {
                return true;
            }
            mpos.set(current.x, current.y, current.z);
            BlockState state = level.getBlockState((BlockPos)mpos);
            if (!state.isAir() && !state.getOcclusionShape(level, (BlockPos)mpos).isEmpty() && state.getCollisionShape(level, (BlockPos)mpos).bounds().move((BlockPos)mpos).contains(current)) {
                return false;
            }
            current = current.add(direction.scale(stepSize));
        }
        return true;
    }

    private static Vec3[] sampleOffsets(Direction face) {
        Vec3[] vec3Array;
        switch (face) {
            case UP: 
            case DOWN: {
                Vec3[] vec3Array2 = new Vec3[5];
                vec3Array2[0] = Vec3.ZERO;
                vec3Array2[1] = new Vec3(0.2, 0.0, 0.0);
                vec3Array2[2] = new Vec3(-0.2, 0.0, 0.0);
                vec3Array2[3] = new Vec3(0.0, 0.0, 0.2);
                vec3Array = vec3Array2;
                vec3Array2[4] = new Vec3(0.0, 0.0, -0.2);
                break;
            }
            case NORTH: 
            case SOUTH: {
                Vec3[] vec3Array3 = new Vec3[5];
                vec3Array3[0] = Vec3.ZERO;
                vec3Array3[1] = new Vec3(0.2, 0.0, 0.0);
                vec3Array3[2] = new Vec3(-0.2, 0.0, 0.0);
                vec3Array3[3] = new Vec3(0.0, 0.2, 0.0);
                vec3Array = vec3Array3;
                vec3Array3[4] = new Vec3(0.0, -0.2, 0.0);
                break;
            }
            default: {
                Vec3[] vec3Array4 = new Vec3[5];
                vec3Array4[0] = Vec3.ZERO;
                vec3Array4[1] = new Vec3(0.0, 0.2, 0.0);
                vec3Array4[2] = new Vec3(0.0, -0.2, 0.0);
                vec3Array4[3] = new Vec3(0.0, 0.0, 0.2);
                vec3Array = vec3Array4;
                vec3Array4[4] = new Vec3(0.0, 0.0, -0.2);
            }
        }
        return vec3Array;
    }

    private static Vec3 getFaceCenter(BlockPos pos, Direction face) {
        return new Vec3((double)pos.getX() + 0.5 + (double)face.getStepX() * 0.501, (double)pos.getY() + 0.5 + (double)face.getStepY() * 0.501, (double)pos.getZ() + 0.5 + (double)face.getStepZ() * 0.501);
    }

    public static boolean isInFallbackMode() {
        return FALLBACK_MODE.get();
    }

    private static synchronized void initExecutors() {
        if (tracerPool == null) {
            int cpus = Math.max(2, Runtime.getRuntime().availableProcessors());
            tracerPool = new ThreadPoolExecutor(Math.max(1, cpus / 4), Math.max(2, cpus / 2), 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(4096), new NamedThreadFactory("Tritium-occl-trace", true), new ThreadPoolExecutor.DiscardPolicy());
        }
        if (timeoutChecker == null) {
            timeoutChecker = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("Tritium-occl-timeout", true));
        }
    }

    static {
        PENDING = new AtomicInteger();
        lastCacheCleanup = System.currentTimeMillis();
        BlockFaceOcclusionCuller.initExecutors();
    }

    private record Key(int levelId, long pos, byte face) {
    }

    private static final class NamedThreadFactory
    implements ThreadFactory {
        private final String baseName;
        private final boolean daemon;
        private final AtomicInteger idx = new AtomicInteger(1);

        private NamedThreadFactory(String baseName, boolean daemon) {
            this.baseName = Objects.requireNonNull(baseName);
            this.daemon = daemon;
        }

        @Override
        public Thread newThread(@NotNull Runnable r) {
            Thread t = new Thread(r, this.baseName + "-" + this.idx.getAndIncrement());
            t.setDaemon(this.daemon);
            t.setPriority(4);
            return t;
        }
    }
}

