/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.mixin.cache;

import java.util.Optional;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import org.craftamethyst.tritium.config.TritiumConfigBase;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractFurnaceBlockEntity.class})
public abstract class AbstractFurnaceBlockEntityMixin {
    @Unique
    private static final int CACHE_INVALIDATION_TICKS = 200;
    @Unique
    private static final int DEFAULT_COOK_TIME = 200;
    @Unique
    private int tritium$cacheTicks = 0;
    @Unique
    @Nullable
    private RecipeHolder<? extends AbstractCookingRecipe> tritium$cachedRecipe;
    @Unique
    @Nullable
    private ItemStack tritium$cachedInput;
    @Unique
    private boolean tritium$cacheMissed = false;
    @Shadow
    @Final
    private RecipeManager.CachedCheck<SingleRecipeInput, ? extends AbstractCookingRecipe> quickCheck;
    @Shadow
    protected NonNullList<ItemStack> items;

    @Shadow
    private static int getTotalCookTime(Level level, AbstractFurnaceBlockEntity blockEntity) {
        throw new AssertionError();
    }

    @Unique
    private boolean tritium$isInputChanged(ItemStack currentInput) {
        if (this.tritium$cachedInput == null) {
            return !currentInput.isEmpty();
        }
        if (currentInput.isEmpty()) {
            return true;
        }
        return !ItemStack.isSameItem((ItemStack)this.tritium$cachedInput, (ItemStack)currentInput) || !ItemStack.isSameItemSameComponents((ItemStack)this.tritium$cachedInput, (ItemStack)currentInput);
    }

    @Unique
    @Nullable
    private RecipeHolder<? extends AbstractCookingRecipe> tritium$getCachedRecipe(ItemStack currentInput) {
        if (!TritiumConfigBase.Performance.FastFurnace.fastFurnace) {
            return null;
        }
        ++this.tritium$cacheTicks;
        if (this.tritium$cacheTicks >= 200 || this.tritium$isInputChanged(currentInput)) {
            this.tritium$resetCache();
            return null;
        }
        return this.tritium$cacheMissed ? null : this.tritium$cachedRecipe;
    }

    @Unique
    private void tritium$updateCache(Level level, ItemStack input) {
        if (!TritiumConfigBase.Performance.FastFurnace.fastFurnace) {
            return;
        }
        this.tritium$resetCache();
        if (input.isEmpty()) {
            return;
        }
        SingleRecipeInput recipeInput = new SingleRecipeInput(input);
        Optional recipe = this.quickCheck.getRecipeFor((RecipeInput)recipeInput, level);
        if (recipe.isPresent()) {
            this.tritium$cachedRecipe = (RecipeHolder)recipe.get();
            this.tritium$cachedInput = input.copy();
            this.tritium$cacheMissed = false;
        } else {
            this.tritium$cacheMissed = true;
            this.tritium$cachedInput = input.copy();
        }
        this.tritium$cacheTicks = 0;
    }

    @Unique
    private void tritium$resetCache() {
        if (!TritiumConfigBase.Performance.FastFurnace.fastFurnace) {
            return;
        }
        this.tritium$cachedRecipe = null;
        this.tritium$cachedInput = null;
        this.tritium$cacheMissed = false;
        this.tritium$cacheTicks = 0;
    }

    @Redirect(method={"serverTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/AbstractFurnaceBlockEntity;getTotalCookTime(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/level/block/entity/AbstractFurnaceBlockEntity;)I"))
    private static int redirectGetTotalCookTime(Level level, AbstractFurnaceBlockEntity blockEntity) {
        if (!TritiumConfigBase.Performance.FastFurnace.fastFurnace) {
            return AbstractFurnaceBlockEntityMixin.getTotalCookTime(level, blockEntity);
        }
        return ((AbstractFurnaceBlockEntityMixin)blockEntity).tritium$getCachedTotalCookTime(level);
    }

    @Unique
    private int tritium$getCachedTotalCookTime(Level level) {
        if (!TritiumConfigBase.Performance.FastFurnace.fastFurnace) {
            return AbstractFurnaceBlockEntityMixin.getTotalCookTime(level, (AbstractFurnaceBlockEntity)this);
        }
        if (this.items.isEmpty()) {
            if (this.tritium$cachedInput != null || !this.tritium$cacheMissed) {
                this.tritium$resetCache();
            }
            return 200;
        }
        ItemStack currentInput = (ItemStack)this.items.getFirst();
        if (currentInput.isEmpty()) {
            if (this.tritium$cachedInput != null || !this.tritium$cacheMissed) {
                this.tritium$resetCache();
            }
            return 200;
        }
        RecipeHolder<? extends AbstractCookingRecipe> recipe = this.tritium$getCachedRecipe(currentInput);
        if (recipe == null) {
            if (!this.tritium$cacheMissed) {
                this.tritium$updateCache(level, currentInput);
                recipe = this.tritium$cachedRecipe;
            }
            if (recipe == null) {
                return 200;
            }
        }
        return ((AbstractCookingRecipe)recipe.value()).getCookingTime();
    }

    @Inject(method={"setItem"}, at={@At(value="HEAD")})
    private void onSetItem(int pIndex, ItemStack pStack, CallbackInfo ci) {
        if (!TritiumConfigBase.Performance.FastFurnace.fastFurnace) {
            return;
        }
        if (!(pIndex != 0 || this.tritium$cachedInput != null && ItemStack.isSameItemSameComponents((ItemStack)this.tritium$cachedInput, (ItemStack)pStack))) {
            this.tritium$resetCache();
        }
    }

    @Inject(method={"setItems"}, at={@At(value="HEAD")})
    private void onSetItems(NonNullList<ItemStack> pItems, CallbackInfo ci) {
        if (!TritiumConfigBase.Performance.FastFurnace.fastFurnace) {
            return;
        }
        this.tritium$resetCache();
    }
}

