/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.mixin.client.renderer.culling;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.craftamethyst.tritium.accessor.EntityRendererAccessor;
import org.craftamethyst.tritium.client.TritiumClient;
import org.craftamethyst.tritium.config.TritiumConfigBase;
import org.craftamethyst.tritium.cull.iface.EntityVisibility;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public class LevelRendererMixin {
    @Unique
    private final Minecraft tritium$mc = Minecraft.getInstance();
    @Final
    @Shadow
    private EntityRenderDispatcher entityRenderDispatcher;

    @Inject(method={"renderEntity"}, at={@At(value="TAIL")}, cancellable=true)
    private void tritium$skipCulledEntityButMaybeRenderNameTag(Entity entity, double cameraX, double cameraY, double cameraZ, float tickDelta, PoseStack matrices, MultiBufferSource consumers, CallbackInfo ci) {
        if (!TritiumConfigBase.Rendering.EntityCulling.enableCulling) {
            return;
        }
        TritiumClient client = TritiumClient.instance;
        if (client == null || !(entity instanceof EntityVisibility)) {
            return;
        }
        EntityVisibility cullable = (EntityVisibility)entity;
        if (cullable.tritium$isForcedVisible() || entity.noCulling) {
            cullable.tritium$setOutOfCamera(false);
            return;
        }
        if (client.shouldSkipEntity(entity)) {
            if (!TritiumConfigBase.Rendering.EntityCulling.enableNameTagCulling && matrices != null && consumers != null && this.tritium$shouldRenderNameTag(entity)) {
                this.tritium$renderNameTag(entity, cameraX, cameraY, cameraZ, tickDelta, matrices, consumers);
            }
            ci.cancel();
            return;
        }
        cullable.tritium$setOutOfCamera(false);
    }

    @Unique
    private boolean tritium$shouldRenderNameTag(Entity entity) {
        EntityRendererAccessor accessor;
        EntityRenderer renderer = this.entityRenderDispatcher.getRenderer(entity);
        return renderer instanceof EntityRendererAccessor && (accessor = (EntityRendererAccessor)renderer).tritium_shouldShowName(entity);
    }

    @Unique
    private void tritium$renderNameTag(Entity entity, double camX, double camY, double camZ, float tickDelta, PoseStack matrices, MultiBufferSource consumers) {
        EntityRenderer renderer = this.entityRenderDispatcher.getRenderer(entity);
        if (!(renderer instanceof EntityRendererAccessor)) {
            return;
        }
        EntityRendererAccessor accessor = (EntityRendererAccessor)renderer;
        double x = Mth.lerp((double)tickDelta, (double)entity.xOld, (double)entity.getX()) - camX;
        double y = Mth.lerp((double)tickDelta, (double)entity.yOld, (double)entity.getY()) - camY;
        double z = Mth.lerp((double)tickDelta, (double)entity.zOld, (double)entity.getZ()) - camZ;
        Vec3 offset = renderer.getRenderOffset(entity, tickDelta);
        matrices.pushPose();
        matrices.translate(x + offset.x, y + offset.y, z + offset.z);
        accessor.tritium_renderNameTag(entity, entity.getDisplayName(), matrices, consumers, this.entityRenderDispatcher.getPackedLightCoords(entity, tickDelta));
        matrices.popPose();
    }
}

