/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.mixin.client.renderer.vertex;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexBuffer;
import java.nio.ByteBuffer;
import org.craftamethyst.tritium.config.TritiumConfigBase;
import org.craftamethyst.tritium.gpu.GpuPlusGL;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={VertexBuffer.class}, priority=499)
public abstract class VertexBufferMixin {
    @Shadow
    private int vertexBufferId;

    @Redirect(method={"uploadVertexBuffer", "uploadIndexBuffer"}, at=@At(value="INVOKE", target="Lcom/mojang/blaze3d/systems/RenderSystem;glBufferData(ILjava/nio/ByteBuffer;I)V"))
    private void tritium$gpuPlusUpload(int target, ByteBuffer data, int usage) {
        if (!TritiumConfigBase.Rendering.GpuPlus.gpuPlus) {
            RenderSystem.glBufferData((int)target, (ByteBuffer)data, (int)usage);
            return;
        }
        if (target == 34962) {
            if (!TritiumConfigBase.Rendering.GpuPlus.gpuPlusVbo) {
                RenderSystem.glBufferData((int)target, (ByteBuffer)data, (int)usage);
                return;
            }
        }
        if (target == 34963) {
            if (!TritiumConfigBase.Rendering.GpuPlus.gpuPlusIndex) {
                RenderSystem.glBufferData((int)target, (ByteBuffer)data, (int)usage);
                return;
            }
        }
        int storageFlags = 256;
        GpuPlusGL.uploadBoundBuffer(target, data, usage, storageFlags);
    }
}

