/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.mixin.jigsaw;

import com.mojang.datafixers.util.Either;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.craftamethyst.tritium.config.TritiumConfigBase;
import org.craftamethyst.tritium.octree.BoxOctree;
import org.craftamethyst.tritium.util.OctreeHolder;
import org.craftamethyst.tritium.util.RotationFailMask;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SinglePoolElement.class})
public abstract class SinglePoolElementMixin {
    @Shadow
    @Final
    protected Either<ResourceLocation, StructureTemplate> template;

    @Inject(method={"place"}, at={@At(value="HEAD")}, cancellable=true, require=1)
    private void tritium$skipIfGlobalRotationsFailed(StructureTemplateManager manager, WorldGenLevel level, StructureManager structureManager, ChunkGenerator generator, BlockPos offset, BlockPos pos, Rotation rotation, BoundingBox box, RandomSource random, LiquidSettings liquidSettings, boolean keepJigsaws, CallbackInfoReturnable<Boolean> cir) {
        if (!TritiumConfigBase.ServerPerformance.JigsawOptimizations.enableJigsawOptimizations) {
            return;
        }
        ResourceLocation id = this.template.left().orElse(null);
        if (id == null) {
            return;
        }
        int templateId = id.hashCode();
        int rotIdx = rotation.ordinal();
        if (TritiumConfigBase.ServerPerformance.JigsawOptimizations.enableOctreeCollisionDetection && RotationFailMask.isFullyFailed(templateId, pos.getX(), pos.getY(), pos.getZ())) {
            cir.setReturnValue((Object)false);
            return;
        }
        BoxOctree octree = OctreeHolder.get();
        if (octree == null) {
            return;
        }
        StructureTemplate tpl = manager.getOrCreate(id);
        BoundingBox bb = tpl.getBoundingBox(new StructurePlaceSettings().setRotation(rotation), pos);
        AABB aabb = new AABB((double)bb.minX(), (double)bb.minY(), (double)bb.minZ(), (double)bb.maxX(), (double)bb.maxY(), (double)bb.maxZ());
        if (TritiumConfigBase.ServerPerformance.JigsawOptimizations.enableOctreeCollisionDetection && octree.intersects(aabb)) {
            if (RotationFailMask.markFailed(templateId, pos.getX(), pos.getY(), pos.getZ(), rotIdx)) {
                // empty if block
            }
            cir.setReturnValue((Object)false);
            return;
        }
        if (TritiumConfigBase.ServerPerformance.JigsawOptimizations.enableOctreeCollisionDetection) {
            VoxelShape shape = Shapes.create((AABB)aabb);
            if (!shape.isEmpty()) {
                octree.addShape(shape, this);
            }
            octree.addShape(shape, this);
        }
    }
}

