/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.config;

import java.util.Arrays;
import java.util.List;
import me.zcraft.tc.annotation.ClientOnly;
import me.zcraft.tc.annotation.ConfigVersion;
import me.zcraft.tc.annotation.Range;
import me.zcraft.tc.annotation.SubCategory;

@ConfigVersion(value=1)
public class TritiumConfigBase {
    @SubCategory(value="Performance")
    public Performance performance = new Performance();
    @ClientOnly
    @SubCategory(value="Rendering")
    public Rendering rendering = new Rendering();
    @ClientOnly
    @SubCategory(value="Client Optimizations")
    public ClientOptimizations clientOptimizations = new ClientOptimizations();
    @SubCategory(value="Network")
    public Network network = new Network();
    @SubCategory(value="Entities")
    public Entities entities = new Entities();
    @SubCategory(value="Tech Optimizations")
    public TechOptimizations techOptimizations = new TechOptimizations();
    @ClientOnly
    @SubCategory(value="Fixes")
    public Fixes fixes = new Fixes();
    @SubCategory(value="Server Performance")
    public ServerPerformance serverPerformance = new ServerPerformance();

    public static class Performance {
        @SubCategory(value="FastBambooLight")
        public FastBambooLight fastBambooLight = new FastBambooLight();

        public static class FastBambooLight {
            public static boolean bambooLight = true;
        }
    }

    @ClientOnly
    public static class Rendering {
        @SubCategory(value="ChestRenderingOpt")
        public CRO cro = new CRO();
        @SubCategory(value="FastBlit")
        public FastBlit fastBlit = new FastBlit();
        @SubCategory(value="GPUPlus")
        public static GpuPlus GpuPlus = new GpuPlus();
        @SubCategory(value="Reflex")
        public Reflex reflex = new Reflex();
        @SubCategory(value="Entity Culling")
        public EntityCulling entityCulling = new EntityCulling();
        @SubCategory(value="Leaf Culling")
        public LeafCulling leafCulling = new LeafCulling();

        public static class CRO {
            public static boolean chest_rendering_optimization = false;
        }

        public static class FastBlit {
            public static boolean fastBlit = true;
        }

        public static class Reflex {
            public static boolean enableReflex = true;
            public static boolean reflexDebug = false;
            @Range(min=-100000.0, max=100000.0)
            public static int reflexOffsetNs = 0;
            @Range(min=0.0, max=1000.0)
            public static int MAX_FPS = 0;
        }

        public static class EntityCulling {
            public static boolean enableCulling = true;
            public static boolean enableBlockEntityCulling = true;
            public static boolean enableTickStopping = false;
            public static boolean enableNameTagCulling = true;
            public static List<String> entityBlacklist = Arrays.asList("minecraft:player", "minecraft:villager");
        }

        public static class LeafCulling {
            public static boolean enableLeafCulling = true;
            public static boolean hideInnerLeaves = false;
            public static boolean enableFaceOcclusionCulling = true;
        }

        public static class GpuPlus {
            public static boolean gpuPlus = true;
            public static boolean gpuPlusVbo = true;
            public static boolean gpuPlusIndex = true;
        }
    }

    @ClientOnly
    public static class ClientOptimizations {
        @SubCategory(value="FastLanguage")
        public static FL FL = new FL();
        @SubCategory(value="FastResourcePack")
        public static FastResourcePack FastResourcePack = new FastResourcePack();
        @SubCategory(value="dynamicFPS")
        public DynamicFPS dynamicFPS = new DynamicFPS();

        public static class DynamicFPS {
            public static boolean enable = true;
            @Range(min=1.0)
            public static int minimizedFPS = 1;
        }

        public static class FL {
            public static boolean fastLanguageSwitch = true;
        }

        public static class FastResourcePack {
            public static boolean resourcePackCache = true;
        }
    }

    public static class Network {
    }

    public static class Entities {
        @SubCategory(value="EntityOpt")
        public EntityOpt entityOpt = new EntityOpt();
        @SubCategory(value="entityStacking")
        public EntityStacking entityStacking = new EntityStacking();

        public static class EntityOpt {
            public static boolean optimizeEntities = true;
            public static boolean tickRaidersInRaid = true;
            public static boolean ite = true;
            @Range(min=1.0, max=256.0)
            public static int horizontalRange = 64;
            @Range(min=1.0, max=256.0)
            public static int verticalRange = 32;
            public static List<String> entityWhitelist = List.of("minecraft:ender_dragon");
        }

        public static class EntityStacking {
            public static boolean enable = true;
            public static boolean lockMaxedStacks = true;
            public static boolean showStackCount = true;
            @Range(min=0.0)
            public static int maxStackSize = 0;
            @Range(min=0.1, max=10.0)
            public static double mergeDistance = 1.5;
            @Range(min=0.0, max=2.0)
            public static int listMode = 0;
            public static List<String> itemList = Arrays.asList("minecraft:item");
        }
    }

    public static class TechOptimizations {
    }

    @ClientOnly
    public static class Fixes {
        @SubCategory(value="Button Fix")
        public ButtonFix buttonFix = new ButtonFix();
        @SubCategory(value="No GLog")
        public NoGLog noGLog = new NoGLog();
        @SubCategory(value="Memory Leak Fix")
        public MemoryLeakFix memoryLeakFix = new MemoryLeakFix();

        public static class ButtonFix {
            public static boolean buttonFix = true;
        }

        public static class NoGLog {
            public static boolean noGLog = true;
        }

        public static class MemoryLeakFix {
            public static boolean AE2WTLibCreativeTabLeakFix = true;
            public static boolean ScreenshotByteBufferLeakFix = true;
        }
    }

    public static class ServerPerformance {
        @SubCategory(value="Noise Sampling Cache")
        public NoiseSamplingCache noiseSamplingCache = new NoiseSamplingCache();

        public static class NoiseSamplingCache {
            public static boolean noiseSamplingCache = true;
        }
    }
}

