/*
 * Decompiled with CFR 0.152.
 */
package tritium.libs.com.github.benmanes.caffeine.cache;

import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import tritium.libs.com.github.benmanes.caffeine.cache.DisabledScheduler;
import tritium.libs.com.github.benmanes.caffeine.cache.ExecutorServiceScheduler;
import tritium.libs.com.github.benmanes.caffeine.cache.GuardedScheduler;
import tritium.libs.com.github.benmanes.caffeine.cache.SystemScheduler;
import tritium.libs.org.jspecify.annotations.NullMarked;
import tritium.libs.org.jspecify.annotations.Nullable;

@NullMarked
@FunctionalInterface
public interface Scheduler {
    public Future<? extends @Nullable Object> schedule(Executor var1, Runnable var2, long var3, TimeUnit var5);

    public static Scheduler disabledScheduler() {
        return DisabledScheduler.INSTANCE;
    }

    public static Scheduler systemScheduler() {
        return SystemScheduler.INSTANCE;
    }

    public static Scheduler forScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        return new ExecutorServiceScheduler(scheduledExecutorService);
    }

    public static Scheduler guardedScheduler(Scheduler scheduler) {
        return scheduler instanceof GuardedScheduler ? scheduler : new GuardedScheduler(scheduler);
    }
}

