/*
 * Decompiled with CFR 0.152.
 */
package tritium.libs.com.github.benmanes.caffeine.cache;

import tritium.libs.com.github.benmanes.caffeine.cache.AsyncCacheLoader;
import tritium.libs.com.github.benmanes.caffeine.cache.Caffeine;
import tritium.libs.com.github.benmanes.caffeine.cache.LocalCacheFactory;
import tritium.libs.com.github.benmanes.caffeine.cache.Node;
import tritium.libs.com.github.benmanes.caffeine.cache.Pacer;
import tritium.libs.com.github.benmanes.caffeine.cache.Scheduler;
import tritium.libs.com.github.benmanes.caffeine.cache.Ticker;
import tritium.libs.com.github.benmanes.caffeine.cache.WSS;
import tritium.libs.com.github.benmanes.caffeine.cache.WriteOrderDeque;
import tritium.libs.org.jspecify.annotations.Nullable;

class WSSW<K, V>
extends WSS<K, V> {
    static final LocalCacheFactory FACTORY = WSSW::new;
    final Ticker ticker;
    final WriteOrderDeque<Node<K, V>> writeOrderDeque;
    volatile long expiresAfterWriteNanos;
    final Pacer pacer;

    WSSW(Caffeine<K, V> caffeine, @Nullable AsyncCacheLoader<? super K, V> asyncCacheLoader, boolean bl) {
        super(caffeine, asyncCacheLoader, bl);
        this.ticker = caffeine.getTicker();
        this.writeOrderDeque = new WriteOrderDeque();
        this.expiresAfterWriteNanos = caffeine.getExpiresAfterWriteNanos();
        this.pacer = caffeine.getScheduler() == Scheduler.disabledScheduler() ? null : new Pacer(caffeine.getScheduler());
    }

    @Override
    public final Ticker expirationTicker() {
        return this.ticker;
    }

    @Override
    protected final WriteOrderDeque<Node<K, V>> writeOrderDeque() {
        return this.writeOrderDeque;
    }

    @Override
    protected final boolean expiresAfterWrite() {
        return true;
    }

    @Override
    protected final long expiresAfterWriteNanos() {
        return this.expiresAfterWriteNanos;
    }

    @Override
    protected final void setExpiresAfterWriteNanos(long l) {
        this.expiresAfterWriteNanos = l;
    }

    @Override
    public final Pacer pacer() {
        return this.pacer;
    }
}

