/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.event;

import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.minecraftforge.eventbus.api.Event;
import org.craftamethyst.tritium.TritiumCommon;
import org.craftamethyst.tritium.config.TritiumConfigBase;
import org.craftamethyst.tritium.event.IEventListener;

public class LambdaEventListenerFactory {
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();

    public static IEventListener createStaticListener(Method method) throws Throwable {
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException("Method must be static: " + String.valueOf(method));
        }
        method.setAccessible(true);
        MethodHandle methodHandle = LOOKUP.unreflect(method);
        MethodType samType = MethodType.methodType(Void.TYPE, Event.class);
        CallSite callSite = LambdaMetafactory.metafactory(LOOKUP, "invoke", MethodType.methodType(IEventListener.class), samType, methodHandle, methodHandle.type());
        return callSite.getTarget().invokeExact();
    }

    public static IEventListener createInstanceListener(Object instance, Method method) throws Throwable {
        if (Modifier.isStatic(method.getModifiers())) {
            throw new IllegalArgumentException("Method must be non-static: " + String.valueOf(method));
        }
        method.setAccessible(true);
        MethodHandle methodHandle = LOOKUP.unreflect(method);
        MethodHandle boundHandle = methodHandle.bindTo(instance);
        MethodType samType = MethodType.methodType(Void.TYPE, Event.class);
        CallSite callSite = LambdaMetafactory.metafactory(LOOKUP, "invoke", MethodType.methodType(IEventListener.class), samType, boundHandle, boundHandle.type());
        return callSite.getTarget().invokeExact();
    }

    public static IEventListener createListener(Object instance, Method method) {
        if (!TritiumConfigBase.TechOptimizations.lambdaEventListeners) {
            return new ReflectionFallbackListener(instance, method);
        }
        try {
            if (Modifier.isStatic(method.getModifiers())) {
                return LambdaEventListenerFactory.createStaticListener(method);
            }
            if (instance == null) {
                throw new IllegalArgumentException("Instance required for non-static method: " + String.valueOf(method));
            }
            return LambdaEventListenerFactory.createInstanceListener(instance, method);
        }
        catch (Throwable t) {
            TritiumCommon.LOG.error("Failed to create lambda event listener for method: {}", (Object)method, (Object)t);
            return new ReflectionFallbackListener(instance, method);
        }
    }

    private static class ReflectionFallbackListener
    implements IEventListener {
        private final Object instance;
        private final Method method;

        ReflectionFallbackListener(Object instance, Method method) {
            this.instance = instance;
            this.method = method;
            method.setAccessible(true);
        }

        @Override
        public void invoke(Event event) {
            try {
                this.method.invoke(this.instance, event);
            }
            catch (Exception e) {
                TritiumCommon.LOG.error("Error invoking event listener: {}", (Object)this.method, (Object)e);
            }
        }
    }
}

