/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.mixin.entity;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import org.craftamethyst.tritium.mixin.entity.EntityCollisionContextAccessor;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityCollisionContext.class})
public class EntityCollisionContextMixin {
    @Shadow
    @Final
    private Entity f_166002_;
    @Unique
    private boolean tritium$heldItemInitialized = false;
    @Unique
    private boolean tritium$fluidPredicateInitialized = false;

    @Inject(method={"isHoldingItem"}, at={@At(value="HEAD")})
    private void initHeldItemOnDemand(Item item, CallbackInfoReturnable<Boolean> cir) {
        if (!this.tritium$heldItemInitialized) {
            this.tritium$initializeHeldItem();
        }
    }

    @Inject(method={"canStandOnFluid"}, at={@At(value="HEAD")})
    private void initFluidPredicateOnDemand(FluidState p_205115_, FluidState p_205116_, CallbackInfoReturnable<Boolean> cir) {
        if (!this.tritium$fluidPredicateInitialized) {
            this.tritium$initializeFluidPredicate();
        }
    }

    @Unique
    private void tritium$initializeHeldItem() {
        Entity entity = this.f_166002_;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            ((EntityCollisionContextAccessor)((Object)this)).setHeldItem(livingEntity.m_21205_());
        }
        this.tritium$heldItemInitialized = true;
    }

    @Unique
    private void tritium$initializeFluidPredicate() {
        Entity entity = this.f_166002_;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            ((EntityCollisionContextAccessor)((Object)this)).setCanStandOnFluid(arg_0 -> ((LivingEntity)livingEntity).m_203441_(arg_0));
        }
        this.tritium$fluidPredicateInitialized = true;
    }

    @Inject(method={"isHoldingItem"}, at={@At(value="RETURN")})
    private void afterIsHoldingItem(Item item, CallbackInfoReturnable<Boolean> cir) {
        if (!this.tritium$heldItemInitialized) {
            this.tritium$heldItemInitialized = true;
        }
    }

    @Inject(method={"canStandOnFluid"}, at={@At(value="RETURN")})
    private void afterCanStandOnFluid(FluidState p_205115_, FluidState p_205116_, CallbackInfoReturnable<Boolean> cir) {
        if (!this.tritium$fluidPredicateInitialized) {
            this.tritium$fluidPredicateInitialized = true;
        }
    }
}

