/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.mixin.packs;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.packs.FilePackResources;
import net.minecraft.server.packs.PackType;
import org.craftamethyst.tritium.config.TritiumConfigBase;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FilePackResources.class})
public abstract class FilePackResourcesMixin {
    @Unique
    private ConcurrentHashMap<PackType, Set<String>> tritium$namespaceCache = null;

    @Inject(method={"getNamespaces"}, at={@At(value="RETURN")}, cancellable=true)
    private void cacheNamespaces(PackType type, CallbackInfoReturnable<Set<String>> cir) {
        Set result;
        if (!TritiumConfigBase.ClientOptimizations.FastResourcePack.resourcePackCache) {
            return;
        }
        if (this.tritium$namespaceCache == null) {
            this.tritium$namespaceCache = new ConcurrentHashMap();
        }
        if ((result = (Set)cir.getReturnValue()) != null && !result.isEmpty()) {
            this.tritium$namespaceCache.put(type, result);
        }
    }

    @Inject(method={"getNamespaces"}, at={@At(value="HEAD")}, cancellable=true)
    private void useCachedNamespaces(PackType type, CallbackInfoReturnable<Set<String>> cir) {
        Set<String> cached;
        if (!TritiumConfigBase.ClientOptimizations.FastResourcePack.resourcePackCache) {
            return;
        }
        if (this.tritium$namespaceCache != null && (cached = this.tritium$namespaceCache.get(type)) != null) {
            cir.setReturnValue(cached);
        }
    }
}

