/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.mixin.server;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import org.craftamethyst.tritium.TritiumCommon;
import org.craftamethyst.tritium.config.TritiumConfigBase;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MinecraftServer.class})
public abstract class AsyncWorldSaveMixin {
    @Unique
    private static final ExecutorService SAVE_EXECUTOR = Executors.newSingleThreadExecutor(r -> {
        Thread thread = new Thread(r, "Tritium-Async-World-Save");
        thread.setDaemon(true);
        return thread;
    });
    @Shadow
    private volatile boolean f_129764_;

    @Shadow
    public abstract Iterable<ServerLevel> m_129785_();

    @Inject(method={"saveAllChunks(ZZZ)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSaveAllChunks(boolean suppressLogs, boolean flush, boolean forced, CallbackInfoReturnable<Boolean> cir) {
        if (!TritiumConfigBase.ServerPerformance.asyncWorldSave) {
            return;
        }
        if (!this.f_129764_ && forced) {
            TritiumCommon.LOG.info("Using async world save on server shutdown");
            CompletableFuture<Void> saveFuture = CompletableFuture.runAsync(() -> {
                try {
                    for (ServerLevel level : this.m_129785_()) {
                        TritiumCommon.LOG.info("Async saving world: {}", (Object)level.m_46472_().m_135782_());
                        level.m_8643_(null, flush, level.f_8564_);
                    }
                    TritiumCommon.LOG.info("Async world save completed");
                }
                catch (Exception e) {
                    TritiumCommon.LOG.error("Error during async world save", (Throwable)e);
                }
            }, SAVE_EXECUTOR);
            int timeout = TritiumConfigBase.ServerPerformance.asyncWorldSaveTimeoutSeconds;
            try {
                saveFuture.get(timeout, TimeUnit.SECONDS);
                cir.setReturnValue((Object)true);
            }
            catch (Exception e) {
                TritiumCommon.LOG.error("Async world save timeout or error", (Throwable)e);
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Inject(method={"stopServer()V"}, at={@At(value="HEAD")})
    private void onStopServer(CallbackInfo ci) {
        TritiumCommon.LOG.info("Server stopping, preparing async world save");
    }

    @Inject(method={"stopServer()V"}, at={@At(value="TAIL")})
    private void afterStopServer(CallbackInfo ci) {
        SAVE_EXECUTOR.shutdown();
        try {
            if (!SAVE_EXECUTOR.awaitTermination(5L, TimeUnit.SECONDS)) {
                SAVE_EXECUTOR.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            SAVE_EXECUTOR.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

