/*
 * Decompiled with CFR 0.152.
 */
package org.craftamethyst.tritium.octree;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BoxOctree {
    private static final int MAX_DEPTH = 6;
    private static final int MIN_SIZE = 16;
    private static final int MAX_OBJECTS_PER_NODE = 8;
    private final OctreeNode root;
    private final AABB bounds;

    public BoxOctree(AABB bounds) {
        this.bounds = bounds;
        this.root = new OctreeNode(bounds, 0);
    }

    public void addShape(VoxelShape shape, Object owner) {
        AABB shapeBounds = shape.m_83215_();
        this.root.addObject(new OctreeObject(shapeBounds, shape, owner));
    }

    public boolean intersects(AABB box) {
        return this.root.intersects(box);
    }

    public boolean intersects(VoxelShape shape) {
        return this.root.intersects(shape.m_83215_());
    }

    public void getIntersectingShapes(AABB box, Consumer<VoxelShape> consumer) {
        this.root.getIntersectingObjects(box, obj -> consumer.accept(obj.shape));
    }

    public void getNearbyShapes(AABB box, Consumer<VoxelShape> consumer, double maxDistance) {
        AABB expandedBox = box.m_82400_(maxDistance);
        this.root.getIntersectingObjects(expandedBox, obj -> consumer.accept(obj.shape));
    }

    public void clear() {
        this.root.clear();
    }

    private static class OctreeNode {
        private final AABB bounds;
        private final int depth;
        private final List<OctreeObject> objects = new ArrayList<OctreeObject>();
        private OctreeNode[] children;
        private boolean isLeaf = true;

        public OctreeNode(AABB bounds, int depth) {
            this.bounds = bounds;
            this.depth = depth;
        }

        public void addObject(OctreeObject obj) {
            if (this.isLeaf) {
                this.objects.add(obj);
                if (this.objects.size() > 8 && this.depth < 6 && this.bounds.m_82362_() > 16.0 && this.bounds.m_82376_() > 16.0 && this.bounds.m_82385_() > 16.0) {
                    this.split();
                }
            } else {
                int index = this.getContainingChildIndex(obj.bounds);
                if (index != -1) {
                    this.children[index].addObject(obj);
                } else {
                    this.objects.add(obj);
                }
            }
        }

        public boolean intersects(AABB box) {
            if (!this.bounds.m_82381_(box)) {
                return false;
            }
            for (OctreeObject obj : this.objects) {
                if (!obj.bounds.m_82381_(box)) continue;
                return true;
            }
            if (!this.isLeaf) {
                for (OctreeNode child : this.children) {
                    if (!child.intersects(box)) continue;
                    return true;
                }
            }
            return false;
        }

        public void getIntersectingObjects(AABB box, Consumer<OctreeObject> consumer) {
            if (!this.bounds.m_82381_(box)) {
                return;
            }
            for (OctreeObject obj : this.objects) {
                if (!obj.bounds.m_82381_(box)) continue;
                consumer.accept(obj);
            }
            if (!this.isLeaf) {
                for (OctreeNode child : this.children) {
                    child.getIntersectingObjects(box, consumer);
                }
            }
        }

        private void split() {
            this.children = new OctreeNode[8];
            double halfX = this.bounds.m_82362_() / 2.0;
            double halfY = this.bounds.m_82376_() / 2.0;
            double halfZ = this.bounds.m_82385_() / 2.0;
            double minX = this.bounds.f_82288_;
            double minY = this.bounds.f_82289_;
            double minZ = this.bounds.f_82290_;
            for (int i = 0; i < 8; ++i) {
                double childMinX = minX + (double)(i & 1) * halfX;
                double childMinY = minY + (double)((i & 2) / 2) * halfY;
                double childMinZ = minZ + (double)((i & 4) / 4) * halfZ;
                AABB childBounds = new AABB(childMinX, childMinY, childMinZ, childMinX + halfX, childMinY + halfY, childMinZ + halfZ);
                this.children[i] = new OctreeNode(childBounds, this.depth + 1);
            }
            ArrayList<OctreeObject> objectsToKeep = new ArrayList<OctreeObject>();
            for (OctreeObject obj : this.objects) {
                int index = this.getContainingChildIndex(obj.bounds);
                if (index != -1) {
                    this.children[index].addObject(obj);
                    continue;
                }
                objectsToKeep.add(obj);
            }
            this.objects.clear();
            this.objects.addAll(objectsToKeep);
            this.isLeaf = false;
        }

        private int getContainingChildIndex(AABB objBounds) {
            if (this.children == null) {
                return -1;
            }
            for (int i = 0; i < 8; ++i) {
                if (!this.children[i].bounds.m_82393_(objBounds.f_82288_, objBounds.f_82289_, objBounds.f_82290_) || !this.children[i].bounds.m_82393_(objBounds.f_82291_, objBounds.f_82292_, objBounds.f_82293_)) continue;
                return i;
            }
            return -1;
        }

        public void clear() {
            this.objects.clear();
            if (!this.isLeaf) {
                for (OctreeNode child : this.children) {
                    child.clear();
                }
                this.children = null;
                this.isLeaf = true;
            }
        }
    }

    private static class OctreeObject {
        public final AABB bounds;
        public final VoxelShape shape;
        public final Object owner;

        public OctreeObject(AABB bounds, VoxelShape shape, Object owner) {
            this.bounds = bounds;
            this.shape = shape;
            this.owner = owner;
        }
    }
}

