/*
 * Decompiled with CFR 0.152.
 */
package me.zcraft.tconfig.config;

import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import me.zcraft.tconfig.annotation.ClientOnly;
import me.zcraft.tconfig.annotation.Range;
import me.zcraft.tconfig.annotation.SubCategory;
import me.zcraft.tconfig.config.ConfigMigration;
import me.zcraft.tconfig.config.ConfigParser;
import me.zcraft.tconfig.config.ConfigValidator;
import me.zcraft.tconfig.config.ConfigValue;
import me.zcraft.tconfig.config.watcher.ConfigFileWatcher;
import org.craftamethyst.tritium.TritiumCommon;

public class TritiumConfig {
    private static final Map<String, TritiumConfig> CONFIG_REGISTRY = new ConcurrentHashMap<String, TritiumConfig>();
    private static final AtomicBoolean SHUTDOWN_HOOK_REGISTERED = new AtomicBoolean(false);
    private final String modId;
    private final Class<?> configClass;
    private final Map<String, ConfigValue<?>> configCache = new ConcurrentHashMap();
    private final Map<String, FieldAccessor> fieldAccessors = new ConcurrentHashMap<String, FieldAccessor>();
    private final Object configLock = new Object();
    private final AtomicReference<Object> configRef = new AtomicReference();
    private String configFileName;
    private boolean isClient = true;
    private boolean registered = false;
    private ConfigParser configParser;
    private ConfigFileWatcher fileWatcher;
    private final List<Runnable> reloadListeners = new ArrayList<Runnable>();

    public TritiumConfig(String modId, Class<?> configClass) {
        this.modId = modId;
        this.configClass = configClass;
        this.configFileName = modId + "_config";
        this.isClient = this.detectClientEnvironment();
        this.validateModIdOwnership(modId);
        this.initializeConfigInstance();
        this.registerShutdownHook();
    }

    public static TritiumConfig register(String modId, Class<?> configClass) {
        if (CONFIG_REGISTRY.containsKey(modId)) {
            throw new IllegalStateException("Config already registered for mod: " + modId);
        }
        TritiumConfig config = new TritiumConfig(modId, configClass);
        config.register();
        CONFIG_REGISTRY.put(modId, config);
        return config;
    }

    public static TritiumConfig getConfig(String modId) {
        TritiumConfig config = CONFIG_REGISTRY.get(modId);
        if (config == null) {
            throw new IllegalStateException("Config not registered for mod: " + modId);
        }
        return config;
    }

    public static Map<String, TritiumConfig> getAllConfigs() {
        return new ConcurrentHashMap<String, TritiumConfig>(CONFIG_REGISTRY);
    }

    private static Object getTypeDefaultValue(Class<?> type) {
        if (type == Boolean.TYPE) {
            return false;
        }
        if (type == Integer.TYPE) {
            return 0;
        }
        if (type == Long.TYPE) {
            return 0L;
        }
        if (type == Double.TYPE) {
            return 0.0;
        }
        if (type == String.class) {
            return "";
        }
        return null;
    }

    private static <T extends Number> T validateRange(Field field, T value, T defaultValue) {
        Range range = field.getAnnotation(Range.class);
        if (range == null) {
            return value;
        }
        double numValue = value.doubleValue();
        double min = range.min();
        double max = range.max();
        if (numValue < min || numValue > max) {
            TritiumCommon.LOG.warn((Object)"Config value {} = {} is out of range [{}, {}], using default: {}");
            return defaultValue;
        }
        return value;
    }

    private static boolean isSimpleType(Class<?> type) {
        return type.isPrimitive() || type == Boolean.class || type == Integer.class || type == Long.class || type == Double.class || type == String.class || type.isEnum() || type == List.class;
    }

    private static String formatFieldNameAsComment(String fieldName) {
        if (fieldName == null || fieldName.isEmpty()) {
            return fieldName;
        }
        StringBuilder result = new StringBuilder();
        result.append(Character.toUpperCase(fieldName.charAt(0)));
        for (int i = 1; i < fieldName.length(); ++i) {
            char c = fieldName.charAt(i);
            if (Character.isUpperCase(c)) {
                result.append(' ').append(c);
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    private boolean detectClientEnvironment() {
        try {
            Class.forName("net.minecraft.client.Minecraft");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private void validateModIdOwnership(String modId) {
        if (CONFIG_REGISTRY.containsKey(modId)) {
            throw new SecurityException("Mod ID already registered: " + modId);
        }
    }

    private void initializeConfigInstance() {
        try {
            Object configInstance = this.configClass.newInstance();
            this.configRef.set(configInstance);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create config instance for mod: " + this.modId, e);
        }
    }

    private void registerShutdownHook() {
        if (SHUTDOWN_HOOK_REGISTERED.compareAndSet(false, true)) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                CONFIG_REGISTRY.values().forEach(TritiumConfig::stop);
                CONFIG_REGISTRY.clear();
            }));
        }
    }

    public void register() {
        if (this.registered) {
            TritiumCommon.LOG.warn((Object)"Config for mod {} is already registered!");
            return;
        }
        this.registered = true;
        try {
            Object newConfig = this.rebuildConfigObject();
            this.configRef.set(newConfig);
            ConfigValidator.validateConfig(newConfig);
            TritiumCommon.LOG.info((Object)"Default configuration validation passed for mod: {}");
        }
        catch (Exception e) {
            TritiumCommon.LOG.error((Object)"Default configuration validation failed for mod {}: {}");
            throw new RuntimeException("Invalid default configuration for mod: " + this.modId, e);
        }
        this.cacheFieldAccessors();
        this.initializeConfigSystem();
        TritiumCommon.LOG.info((Object)"Config registered successfully for mod: {} (environment: {})");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        Iterator<Runnable> iterator = this.configLock;
        synchronized (iterator) {
            Path configPath = this.getConfigPath();
            try {
                this.configCache.values().forEach(ConfigValue::refresh);
                this.configCache.clear();
                if (this.configParser != null) {
                    this.configParser.load();
                    if (ConfigMigration.migrateConfig(configPath, this.configParser, this.configClass)) {
                        throw new RuntimeException("Config migration failed");
                    }
                }
                Object newConfig = this.rebuildConfigObject();
                this.configRef.set(newConfig);
                ConfigValidator.validateConfig(newConfig);
                TritiumCommon.LOG.info((Object)"Configuration reloaded successfully for mod: {}");
            }
            catch (Exception e) {
                TritiumCommon.LOG.error((Object)"Failed to reload configuration for mod: {}");
                throw new RuntimeException("Config reload failed", e);
            }
        }
        for (Runnable listener : this.reloadListeners) {
            try {
                listener.run();
            }
            catch (Exception e) {
                TritiumCommon.LOG.error((Object)"Config reload listener failed", (Throwable)e);
            }
        }
    }

    public void addReloadListener(Runnable listener) {
        this.reloadListeners.add(listener);
    }

    public <T> T get() {
        return (T)this.configRef.get();
    }

    public void stop() {
        if (this.fileWatcher != null) {
            this.fileWatcher.stop();
        }
        this.configCache.clear();
        this.fieldAccessors.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        Object object = this.configLock;
        synchronized (object) {
            Path configPath = this.getConfigPath();
            try {
                String configContent = this.generateConfigFile();
                Files.write(configPath, configContent.getBytes(), new OpenOption[0]);
                TritiumCommon.LOG.debug((Object)"Configuration saved for mod: {}");
            }
            catch (IOException e) {
                TritiumCommon.LOG.error((Object)"Failed to save configuration for mod: {}");
                throw new RuntimeException("Config save failed", e);
            }
        }
    }

    private void cacheFieldAccessors() {
        try {
            this.cacheFieldsRecursive(this.configClass, "");
            TritiumCommon.LOG.debug((Object)"Cached {} field accessors for mod: {}");
        }
        catch (Exception e) {
            TritiumCommon.LOG.error((Object)"Failed to cache field accessors for mod: {}");
        }
    }

    private void initializeConfigSystem() {
        Path configPath = this.getConfigPath();
        if (!Files.exists(configPath, new LinkOption[0])) {
            this.createDefaultConfig(configPath);
        }
        this.configParser = new ConfigParser(configPath);
        if (ConfigMigration.migrateConfig(configPath, this.configParser, this.configClass)) {
            throw new RuntimeException("Initial config migration failed");
        }
        Object newConfig = this.rebuildConfigObject();
        this.configRef.set(newConfig);
        this.fileWatcher = new ConfigFileWatcher(configPath, this::reload);
        this.fileWatcher.start();
    }

    private Object rebuildConfigObject() {
        try {
            Object newConfig = this.configClass.newInstance();
            this.configureObjectRecursive(newConfig, "");
            ConfigValidator.validateConfig(newConfig);
            TritiumCommon.LOG.debug((Object)"Configuration object rebuilt and validated for mod: {}");
            return newConfig;
        }
        catch (Exception e) {
            TritiumCommon.LOG.error((Object)"Failed to rebuild configuration object for mod: {}");
            throw new RuntimeException("Configuration rebuild failed", e);
        }
    }

    private void cacheFieldsRecursive(Class<?> clazz, String prefix) throws Exception {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        for (Field field : clazz.getDeclaredFields()) {
            String fullPath;
            field.setAccessible(true);
            String string = fullPath = prefix.isEmpty() ? field.getName() : prefix + "." + field.getName();
            if (field.isAnnotationPresent(ClientOnly.class) && !this.isClient) continue;
            if (!field.isAnnotationPresent(SubCategory.class)) {
                MethodHandle getter = lookup.unreflectGetter(field);
                MethodHandle setter = lookup.unreflectSetter(field);
                this.fieldAccessors.put(fullPath, new MethodHandleFieldAccessor(getter, setter, field.getType(), () -> {
                    try {
                        Object defaultInstance = field.getDeclaringClass().newInstance();
                        return field.get(defaultInstance);
                    }
                    catch (Exception e) {
                        return TritiumConfig.getTypeDefaultValue(field.getType());
                    }
                }));
                continue;
            }
            this.cacheFieldsRecursive(field.getType(), fullPath);
        }
    }

    private void configureObjectRecursive(Object obj, String prefix) throws Exception {
        for (Field field : obj.getClass().getDeclaredFields()) {
            String fieldPath;
            field.setAccessible(true);
            if (field.isAnnotationPresent(ClientOnly.class) && !this.isClient) continue;
            String string = fieldPath = prefix.isEmpty() ? field.getName() : prefix + "." + field.getName();
            if (field.isAnnotationPresent(SubCategory.class)) {
                Object subObj = field.getType().newInstance();
                this.configureObjectRecursive(subObj, fieldPath);
                field.set(obj, subObj);
                continue;
            }
            if (!TritiumConfig.isSimpleType(field.getType())) continue;
            FieldAccessor accessor = this.fieldAccessors.get(fieldPath);
            if (accessor != null) {
                Object defaultValue = accessor.getDefaultValue();
                ConfigValue<?> configValue = this.getCachedConfigValue(fieldPath, field.getType(), defaultValue);
                Object value = configValue.get();
                if (value instanceof Number) {
                    value = TritiumConfig.validateRange(field, (Number)value, (Number)defaultValue);
                }
                accessor.setValue(obj, value);
                continue;
            }
            TritiumCommon.LOG.warn((Object)"No accessor found for field path: {}");
        }
    }

    private ConfigValue<?> getCachedConfigValue(String key, Class<?> type, Object defaultValue) {
        return this.configCache.computeIfAbsent(key, k -> this.createConfigValueSupplier(key, type, defaultValue));
    }

    private ConfigValue<?> createConfigValueSupplier(String key, Class<?> type, Object defaultValue) {
        if (type == Boolean.TYPE || type == Boolean.class) {
            return new ConfigValue<Boolean>(this.configParser.getBoolean(key, (Boolean)defaultValue));
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return new ConfigValue<Integer>(this.configParser.getInt(key, (Integer)defaultValue));
        }
        if (type == Long.TYPE || type == Long.class) {
            return new ConfigValue<Long>(this.configParser.getLong(key, (Long)defaultValue));
        }
        if (type == Double.TYPE || type == Double.class) {
            return new ConfigValue<Double>(this.configParser.getDouble(key, (Double)defaultValue));
        }
        if (type == String.class) {
            return new ConfigValue<String>(this.configParser.getString(key, (String)defaultValue));
        }
        if (type.isEnum()) {
            return new ConfigValue<Enum>(this.configParser.getEnum(key, (Enum)defaultValue));
        }
        if (List.class.isAssignableFrom(type)) {
            return new ConfigValue<List<String>>(this.configParser.getStringList(key, (List)defaultValue));
        }
        TritiumCommon.LOG.warn((Object)"Unsupported configuration type: {} for key: {} in mod: {}");
        return new ConfigValue<Object>(() -> defaultValue);
    }

    private void createDefaultConfig(Path configPath) {
        try {
            String configContent = this.generateConfigFile();
            Files.createDirectories(configPath.getParent(), new FileAttribute[0]);
            Files.write(configPath, configContent.getBytes(), new OpenOption[0]);
            TritiumCommon.LOG.info((Object)"Default configuration created for mod {} at: {}");
        }
        catch (IOException e) {
            TritiumCommon.LOG.error((Object)"Failed to create default configuration for mod: {}");
        }
    }

    private Path getConfigPath() {
        return Paths.get("config", this.modId, this.configFileName + ".toml");
    }

    private String generateConfigFile() {
        StringBuilder sb = new StringBuilder();
        sb.append("# ").append(this.modId).append(" Configuration\n");
        sb.append("# Generated by TritiumConfig\n");
        sb.append("# Environment: ").append(this.isClient ? "client" : "server").append("\n");
        sb.append("# Client-only sections will not be generated on server side\n");
        sb.append("# Edit this file and it will be automatically reloaded\n");
        sb.append("\n");
        try {
            Object configObj = this.configRef.get();
            for (Field sectionField : this.configClass.getDeclaredFields()) {
                sectionField.setAccessible(true);
                if (sectionField.isAnnotationPresent(ClientOnly.class) && !this.isClient) continue;
                Object section = sectionField.get(configObj);
                String sectionName = sectionField.getName();
                this.generateSectionContent(sb, section, sectionName, "");
            }
        }
        catch (Exception e) {
            TritiumCommon.LOG.error((Object)"Failed to generate configuration content for mod: {}");
        }
        return sb.toString();
    }

    private void generateSectionContent(StringBuilder sb, Object section, String sectionPath, String indent) throws Exception {
        if (section == null) {
            return;
        }
        if (!sectionPath.isEmpty()) {
            sb.append(indent).append("[").append(sectionPath).append("]\n");
        }
        for (Field field : section.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            if (field.isAnnotationPresent(ClientOnly.class) && !this.isClient) continue;
            String fieldName = field.getName();
            Object value = field.get(section);
            if (field.isAnnotationPresent(SubCategory.class)) {
                String newSectionPath = sectionPath.isEmpty() ? fieldName : sectionPath + "." + fieldName;
                this.generateSectionContent(sb, value, newSectionPath, indent);
                continue;
            }
            if (!TritiumConfig.isSimpleType(field.getType())) continue;
            sb.append(indent).append("## ").append(TritiumConfig.formatFieldNameAsComment(fieldName)).append("\n");
            sb.append(indent).append(fieldName).append(" = ");
            if (value instanceof Boolean) {
                sb.append(value.toString().toLowerCase());
            } else if (value instanceof String) {
                sb.append("\"").append(value).append("\"");
            } else if (value instanceof Enum) {
                sb.append("\"").append(((Enum)value).name()).append("\"");
            } else if (value instanceof List) {
                List list = (List)value;
                sb.append("[");
                for (int i = 0; i < list.size(); ++i) {
                    if (i > 0) {
                        sb.append(", ");
                    }
                    sb.append("\"").append((String)list.get(i)).append("\"");
                }
                sb.append("]");
            } else if (value instanceof Long) {
                sb.append(value);
            } else {
                sb.append(value);
            }
            sb.append("\n\n");
        }
        if (!sectionPath.isEmpty()) {
            sb.append("\n");
        }
    }

    public TritiumConfig filename(String name) {
        this.configFileName = name;
        if (this.fileWatcher != null) {
            this.fileWatcher.stop();
        }
        this.initializeConfigSystem();
        return this;
    }

    public String getModId() {
        return this.modId;
    }

    public Class<?> getConfigClass() {
        return this.configClass;
    }

    public boolean isClientEnvironment() {
        return this.isClient;
    }

    private static class MethodHandleFieldAccessor
    implements FieldAccessor {
        private final MethodHandle getter;
        private final MethodHandle setter;
        private final Class<?> type;
        private final SupplierWithException<Object> defaultValueSupplier;

        public MethodHandleFieldAccessor(MethodHandle getter, MethodHandle setter, Class<?> type, SupplierWithException<Object> defaultValueSupplier) {
            this.getter = getter;
            this.setter = setter;
            this.type = type;
            this.defaultValueSupplier = defaultValueSupplier;
        }

        @Override
        public Object getValue(Object obj) throws Exception {
            try {
                return this.getter.invoke(obj);
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void setValue(Object obj, Object value) throws Exception {
            block4: {
                try {
                    Object convertedValue = this.convertValue(value, this.type);
                    int parameterCount = this.setter.type().parameterCount();
                    if (parameterCount == 1) {
                        this.setter.invoke(convertedValue);
                        break block4;
                    }
                    if (parameterCount == 2) {
                        this.setter.invoke(obj, convertedValue);
                        break block4;
                    }
                    throw new RuntimeException("Unexpected setter parameter count: " + parameterCount);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        }

        private Object convertValue(Object value, Class<?> targetType) {
            if (value == null) {
                return TritiumConfig.getTypeDefaultValue(targetType);
            }
            if (targetType.isInstance(value)) {
                return value;
            }
            try {
                if (targetType == Boolean.TYPE || targetType == Boolean.class) {
                    if (value instanceof Boolean) {
                        return value;
                    }
                    if (value instanceof String) {
                        return Boolean.parseBoolean((String)value);
                    }
                    if (value instanceof Number) {
                        return ((Number)value).intValue() != 0;
                    }
                    return false;
                }
                if (targetType == Integer.TYPE || targetType == Integer.class) {
                    if (value instanceof Integer) {
                        return value;
                    }
                    if (value instanceof Number) {
                        return ((Number)value).intValue();
                    }
                    if (value instanceof String) {
                        return Integer.parseInt((String)value);
                    }
                    return 0;
                }
                if (targetType == Double.TYPE || targetType == Double.class) {
                    if (value instanceof Double) {
                        return value;
                    }
                    if (value instanceof Number) {
                        return ((Number)value).doubleValue();
                    }
                    if (value instanceof String) {
                        return Double.parseDouble((String)value);
                    }
                    return 0.0;
                }
                if (targetType == Long.TYPE || targetType == Long.class) {
                    if (value instanceof Long) {
                        return value;
                    }
                    if (value instanceof Number) {
                        return ((Number)value).longValue();
                    }
                    if (value instanceof String) {
                        return Long.parseLong((String)value);
                    }
                    return 0L;
                }
                if (targetType == String.class) {
                    return value.toString();
                }
                if (targetType.isEnum() && value instanceof String) {
                    try {
                        return Enum.valueOf(targetType, ((String)value).trim().toUpperCase());
                    }
                    catch (IllegalArgumentException e) {
                        TritiumCommon.LOG.warn((Object)"Invalid enum value '{}' for type {}, using first enum value");
                        return targetType.getEnumConstants()[0];
                    }
                }
            }
            catch (Exception e) {
                TritiumCommon.LOG.warn((Object)"Failed to convert value '{}' to type {}, using default");
            }
            return TritiumConfig.getTypeDefaultValue(targetType);
        }

        @Override
        public Object getDefaultValue() throws Exception {
            return this.defaultValueSupplier.get();
        }

        @Override
        public Class<?> getType() {
            return this.type;
        }
    }

    @FunctionalInterface
    private static interface SupplierWithException<T> {
        public T get() throws Exception;
    }

    private static interface FieldAccessor {
        public Object getValue(Object var1) throws Exception;

        public void setValue(Object var1, Object var2) throws Exception;

        public Object getDefaultValue() throws Exception;

        public Class<?> getType();
    }
}

